import java.io.*;
import java.net.*;
import org.w3c.dom.*;
import org.w3c.dom.Node;
import oracle.xml.parser.v2.DOMParser;

public class readXmlSample {
 
 static public void main(String[] argv) {
   try  {
      DOMParser parser = new DOMParser();
      parser.parse( new URL(argv[0]) );
      Document doc = parser.getDocument();
      printElements(doc);
   } catch (Exception e) {}
 }

 static void printElements(Document doc)  {
   Element n;  NodeList nl = doc.getElementsByTagName("*");
   for (int i=0; i<nl.getLength(); i++) {
       n = (Element) nl.item(i);
       System.out.println("");
       System.out.println(n.getTagName() + " : " +
                           n .getFirstChild().getNodeValue());
       printElementAttributes( (Element) n);
   }
 }

 static void printElementAttributes(Element el) {
   Node n;    NamedNodeMap nnm = el.getAttributes();
   if (nnm != null) {
    for (int i=0; i<nnm.getLength(); i++) {
     n = nnm.item(i);
     System.out.print("   " + n.getNodeName() + " = " + n.getNodeValue());
    }
   }
 }

}

