<%@ Import Namespace="System.Data.OleDB"%>
<%@ Import Namespace="System.Data" %>
<%@ Page Language="VB" Debug="true" %>
<HTML>
    <SCRIPT LANGUAGE="VB" RUNAT="server">
        Sub Page_Load(Src As Object, E as EventArgs)
            Dim connection as New OleDBConnection("provider=sqloledb;Data Source=localhost;Initial Catalog=pubs;User ID=sa;pwd=;")

		If Not IsPostback Then
		    Connection.Open()
		    Dim command as New OleDbCommand("SELECT * FROM Authors Order By au_lname, au_fname", connection)
		    Dim AuthorDataReader As OleDbDataReader = command.ExecuteReader()
            Dim sFullName as String
            While AuthorDataReader.Read()
                sFullName = AuthorDataReader.Item("au_fname") & " " & AuthorDataReader.Item("au_lname")
                authorlist.items.add(New ListItem(sFullName, AuthorDataReader.Item("au_id")))
            End While
            AuthorDataReader.Close()
            Connection.Close()
            BindData()
        End If
        End Sub

    Function GetTitles(ByVal au_id As String) As DataView
        Try
            Dim connection as New OleDBConnection("provider=sqloledb;Data Source=localhost;Initial Catalog=pubs;User ID=sa;pwd=;")
            Dim command As New OleDBDataAdapter("SELECT titles.title_id, titles.title, titles.price, titles.ytd_sales,titleauthor.au_ord,authors.au_id, titles.pub_id FROM authors INNER JOIN titleauthor ON authors.au_id = titleauthor.au_id INNER JOIN titles ON titleauthor.title_id = titles.title_id", connection)
            Dim dataset As New DataSet()
            Dim dataView1 as DataView
            command.Fill(dataset, "TitleAuthor")
            dataView1 = new DataView(dataset.Tables("TitleAuthor"))
            dataView1.RowFilter = "au_id='" & au_id &"'"
            Return dataview1
        Catch myException as Exception
            Message.Text = ("Exception: " + myException.ToString()) 
        End Try
    End Function

    Function BindData()
        Try
            Dim TitlesDataView As DataView = GetTitles(authorlist.SelectedItem.Value)
            titleGrid.DataSource = TitlesDataView
            titleGrid.DataBind()
        Catch myException as Exception
            Message.Text = ("Exception: " + myException.ToString()) 
        End Try
    End Function
    Sub OnSorted(source As Object , e As DataGridSortCommandEventArgs)
        Try
            Dim sSortField as String
            Dim TitlesDataView As DataView = GetTitles(authorlist.SelectedItem.Value)
            Dim bSortAsc as Integer
            sSortField = e.SortExpression.ToString()
            source.EditItemIndex=-1
            if Session("bsortAsc") = Nothing Then
                Session("bsortAsc") = 1
            Else
                bSortAsc= Session("bsortAsc")
            End If		
            If bSortAsc = 1 Then
                Session("bSortAsc") = 0
                TitlesDataView.Sort= sSortField & " DESC"
                Message.Text ="Tri descendant sur " & sSortField
            Elseif bSortAsc =0 Then
                Session("bSortAsc")= 1
                TitlesDataView.Sort= sSortField & " ASC"
                Message.Text ="Tri ascendant sur " & sSortField
            Else
                Message.Text="bSortAsc a &eacute;chou&eacute;"
            End If	
            titleGrid.DataSource = TitlesDataView
            titlegrid.databind()
        Catch myException as Exception
            Message.Text = ("Exception: " + myException.ToString()) 
        End Try
    End Sub	
    Sub OnEdit(sender As Object, E As DataGridCommandEventArgs)
        Try
            sender.EditItemIndex = E.Item.ItemIndex
            BindData()
            Message.Text = "Etat : Mode &eacute;dition"
        Catch myException as Exception
            Message.Text = ("Exception: " + myException.ToString()) 
        End Try
    End Sub
    Sub OnUpdate(sender As Object, E As DataGridCommandEventArgs)
        Try
            Dim sTitleId as String
            Dim dPrice as decimal
            Dim txtBox as TextBox
            Dim valCtrl as CompareValidator
            valCtrl = e.item.findcontrol("valeditprice")
            If valCtrl.isValid
                sTitleId = titlegrid.datakeys.item(e.item.itemindex)
                txtBox = e.item.findcontrol("editprice")
                dPrice =txtBox.Text
                UpdateTitles(dPrice, sTitleId)
                titleGrid.EditItemIndex=-1
                BindData()
                Message.Text ="Etat : Mise &agrave; jour termin&eacute;e"
            Else
                Message.Text ="Etat : Pas de mise &agrave jour, &eacute;ch&egrave;c de la validation"
            End If
        Catch myException as Exception
            Message.Text = ("Exception: " + myException.ToString()) 
        End Try
    End Sub
    Sub OnDelete(sender As Object, E As DataGridCommandEventArgs)
        Try
            Dim sTitleId as String
            Dim sAuthorID as String
            sender.EditItemIndex=-1
            sTitleId = titlegrid.datakeys.item(e.item.itemindex)
            sAuthorID = AuthorList.SelectedItem.Value
            DeleteTitles(sTitleId, sAuthorId)
            BindData()
            Message.Text="Etat : Suppression r&eacute;ussie"	
        Catch myException as Exception
            Message.Text = ("Exception: " + myException.ToString()) 
        End Try
    End Sub
    Sub OnCancel(sender As Object, E As DataGridCommandEventArgs)
        Try
            sender.EditItemIndex=-1
            BindData()
            Message.Text = "Etat : Mise &agrave; jour annul&eacute;e"
        Catch myException as Exception
            Message.Text = ("Exception: " + myException.ToString()) 
        End Try
    End Sub


    Sub UpdateTitles(price As Decimal, title_id As String)
        Dim connection as New OleDBConnection("provider=sqloledb;Data Source=localhost;Initial Catalog=pubs;User ID=sa;pwd=;")
        Dim command as New OleDbCommand("UPDATE titles SET [price]=? WHERE [title_id] =?", connection)
	Dim param0 as New OleDBParameter("price", OleDBType.Currency)
	param0.Value = price
	command.Parameters.Add(param0)
        Dim param1 as New OleDBParameter("title_id", OleDBType.VarChar)
	param1.Value = title_id
	command.Parameters.Add(param1)
	connection.Open()
	command.ExecuteNonQuery()
	connection.Close()
    End Sub
    Sub DeleteTitles(title_id as String, au_id as String)
        Dim connection as New OleDBConnection("provider=sqloledb;Data Source=localhost;Initial Catalog=pubs;User ID=sa;pwd=;")
        Dim command as New OleDbCommand("DELETE FROM TitleAuthor WHERE [title_id]=? And [au_id]=?", connection)
        Dim param0 as New OleDBParameter("title_id", OleDBType.VarChar)
        param0.Value = title_id
        command.Parameters.Add(param0)
        Dim param1 as New OleDBParameter("au_id", OleDBType.VarChar)
        param1.Value = au_id
        command.Parameters.Add(param1)
        connection.Open()
        command.ExecuteNonQuery()
        connection.Close()
    End Sub
    Sub authorlist_SelectedIndexChanged(sender As Object , e As System.EventArgs)
        titlegrid.CurrentPageIndex=0
        BindData()
        Message.Text="Etat : Changement auteur"
    End Sub
    Sub OnPageIndexChanged(sender As Object, e As DataGridPageChangedEventArgs)
        BindDAta()
        Message.Text="Status: Attempted Move to Page " & CSTR(e.newpageindex + 1)
    End Sub

    </SCRIPT>
    <BODY>
        <FORM METHOD="post" RUNAT="server" ID="defaultform">
            <P>
                <ASP:LABEL RUNAT="server" ID="Label1">Choix d'un auteur: </ASP:LABEL>
                <ASP:DROPDOWNLIST ID="authorlist" RUNAT="SERVER" AUTOPOSTBACK="true" ONSELECTEDINDEXCHANGED="authorlist_SelectedIndexChanged"></ASP:DROPDOWNLIST>
            </P>
            <P>
                <ASP:DATAGRID ID="titleGrid" RUNAT="SERVER" FORECOLOR="Black" AUTOGENERATECOLUMNS="false" DATAKEYFIELD="title_id" ONPAGEINDEXCHANGED="OnPageIndexChanged" ONEDITCOMMAND="OnEdit" ONCANCELCOMMAND="OnCancel" ONUPDATECOMMAND="OnUpdate" ONDELETECOMMAND="OnDelete" ONSORTCOMMAND="OnSorted" ALLOWSORTING="True" ALLOWPAGING="True" PAGESIZE="5" PAGERSTYLE-MODE="NextPrev" PAGERSTYLE-HORIZONTALALIGN="Center">
                    <ALTERNATINGITEMSTYLE BACKCOLOR="Gainsboro" />
                    <FOOTERSTYLE BACKCOLOR="Silver" FORECOLOR="White" />
                    <ITEMSTYLE BACKCOLOR="White" />
                    <HEADERSTYLE BACKCOLOR="Navy" FORECOLOR="White" FONT-BOLD="True" />
                    <COLUMNS>
                        <ASP:BOUNDCOLUMN HEADERTEXT="Titre" DATAFIELD="Title" SORTEXPRESSION="Title" READONLY="True"></ASP:BOUNDCOLUMN>
                        <ASP:TEMPLATECOLUMN HEADERTEXT="Prix Unitaire" SORTEXPRESSION="Price">
                            <ITEMTEMPLATE>
                                <ASP:LABEL id="Label2" RUNAT="server" TEXT='<%# String.Format("{0:C}", Container.DataItem("price"))%>' WIDTH="50" AUTOSIZE="True"></ASP:LABEL>
                            </ITEMTEMPLATE>
                            <EDITITEMTEMPLATE>
                                <ASP:TEXTBOX id="editprice" RUNAT="Server" TEXT='<%# Container.DataItem("price")%>' WIDTH="50"></ASP:TEXTBOX>
                                <BR>
                                <ASP:COMPAREVALIDATOR id="valeditprice" RUNAT="server" CONTROLTOVALIDATE="editprice" ERRORMESSAGE="Vous devez donner une valeur mon&eacute;taire positive." TYPE="Currency" OPERATOR="GreaterThan" VALUETOCOMPARE="0" DISPLAY="dynamic"></ASP:COMPAREVALIDATOR>
                            </EDITITEMTEMPLATE>
                        </ASP:TEMPLATECOLUMN>
                        <ASP:BOUNDCOLUMN HEADERTEXT="Ventes DDA" DATAFIELD="ytd_sales" SORTEXPRESSION="ytd_sales" DATAFORMATSTRING="{0:C}" READONLY="True"></ASP:BOUNDCOLUMN>
                        <ASP:EDITCOMMANDCOLUMN EDITTEXT="Edition" CANCELTEXT="Annuler" UPDATETEXT="OK"></ASP:EDITCOMMANDCOLUMN>
                        <ASP:BUTTONCOLUMN TEXT="Supprimer" COMMANDNAME="Delete"></ASP:BUTTONCOLUMN>
                    </COLUMNS>
                </ASP:DATAGRID>
            </P>
            <P>
                <ASP:LABEL ID="Message" RUNAT="SERVER" BACKCOLOR="Navy" FORECOLOR="yellow">
					Etat : OK
				</ASP:LABEL>
            </P>
        </FORM>
    </BODY>
</HTML>


