<%@ Import Namespace="System.Diagnostics"%>
<%@ Import Namespace="System.Exception" %>
<%@ Import Namespace="System.Data.OleDB" %>
<%@ Import Namespace="System.Data" %>
<%@ Page Language="VB" Debug="False" Trace="False" %>
<HTML>
    <SCRIPT LANGUAGE="VB" RUNAT="server">

        Sub ExecuteDBCodeBtn_Click(Sender As Object, E as EventArgs)
            Try
            	Dim MyDataset As DataSet = GetRecords()
            	grid1.DataSource = MyDataset.Tables(0).DefaultView
            	grid1.DataBind()
	        Catch ex as Exception
		        Dim oLabel as new Label()
		        Dim sMess as String
		        oLabel.Text=""
		        oLabel.Id="ExecuteDBCodeBtn_ErrorLabel"
		        Page.Controls.Add(oLabel)
		        sMess = sMess & "<b><p>Code erreur produite</p></b>"
		        sMess = sMess & "<ul><li>" & ex.message & "</li></ul>"
		        oLabel.Text = oLabel.Text & sMess
	        End Try
        End Sub
        
        Function GetRecords() As DataSet
            Try	
	            Dim connection as New OleDBConnection(txtConnStr.Text)
                Dim command as New OleDBDataAdapter(txtSQLStr.Text, connection)
                Dim dataset As New DataSet()
            	command.Fill(dataset, "dataset")
		        Return dataset
	        Catch myException as OleDBException
		        OleDBErrorHandler(myException)
	        End Try        
        End Function
	
	    Function OleDBErrorHandler(ByVal myException as OleDBException)
		    Dim sMess as String
		    Dim oLabel as new Label()
		    Dim eItem as OleDBError
    		
		    'Ajoutez de maniere dynamique un label  la page pour afficher les erreurs
		    oLabel.Text = ""
		    oLabel.Id="OleDBLabel"
   		    Page.Controls.Add(new LiteralControl("<hr>"))
		    Page.Controls.Add(oLabel)
    		
		    'Faites une boucle  travers les erreurs dans OleDBException
		    sMess=sMess & "<p><b>Une erreur " & myException.ErrorCode.ToString() & " s'est produite dans la base de donn&eacute;es : " & myException.Message &"</b></p>"
		    sMess=sMess & "<p>StackTrace : " & myException.StackTrace.ToString() &"</p>"
		    sMess=sMess & "<p>TargetSite: " & myException.TargetSite.ToString() &"</p>"
		    For each eItem in myException.Errors
 			    sMess=sMess & "<ul>"
			    sMess = sMess &"<li>Message d'erreur : " & eItem.Message & "</li>"
			    sMess = sMess &"<li>Source de l'erreur: " & eItem.Source & "</li>"
			    sMess = sMess &"<li>Id erreur native: " & eItem.NativeError.ToString() & "</li>"
			    sMess = sMess &"<li>Etat SQL : " & eItem.SQLState & "</li>"
			    sMess=sMess & "</ul>"
			    oLabel.Text = oLabel.Text & sMess		
		    Next
		    WriteEvent(myException)
	    End Function
	
	    Function WriteEvent(ByVal myException as Exception)
 		    Dim sPage as String = Request.Path 
  		    Dim Message As String = "Url " & sPage
		    Dim sLogName As String = "application" 
 		    Dim oLog as New EventLog 

		    Message = Message  & " Erreur: " 
		    Message = Message  & myexception.message
		    If (Not EventLog.SourceExists(sLogName)) Then 
	       		    EventLog.CreateEventSource(sLogName,sLogName) 
		    End if 
		    oLog.Source = sLogName 
		    oLog.WriteEntry(Message, EventLogEntryType.Error)
	    End Function
    </SCRIPT>
    <BODY>
        <FORM RUNAT="server" ID="Form1">
            <H1>
                ASP.NET Gestion d'une exception OleDB
            </H1>
            <P>
                Cet exemple est tr&egrave;s utile pour tester quelques types d'erreur qui peuvent se produire lors d'une connexion OleDB &agrave; une source de donn&eacute;es. Essayez de simuler des erreurs dans la cha&icirc;ne de connexion et dans l'instruction SQL pour voir la mani&egrave;re de rapporter la gestion d'erreurs..
            </P>
            <P>
                <ASP:LABEL RUNAT="Server" ID="Label1">Cha&icirc;ne de connexion</ASP:LABEL>
                <ASP:TEXTBOX ID="txtConnStr" RUNAT="server" WRAP="False" WIDTH="800">provider=sqloledb;Data Source=127.0.0.1;Initial Catalog=pubs;User ID=sa;pwd=;</ASP:TEXTBOX>
            </P>
            <P>
                <ASP:LABEL RUNAT="Server" ID="Label2">Instruction SQL</ASP:LABEL>
                <ASP:TEXTBOX ID="txtSQLStr" RUNAT="server" WRAP="False" WIDTH="800">SELECT * FROM 
GENEREZ UNE ERREUR SQL</ASP:TEXTBOX>
            </P>
            <P>
                <ASP:BUTTON TEXT="Ex&eacute;cuter les codes de la base de donn&eacute;es" ONCLICK="ExecuteDBCodeBtn_Click" RUNAT="server" ID="Button1" />
            </P>
            <P>
                <ASP:DATAGRID ID="grid1" RUNAT="server" />
            </P>
        </FORM>
    </BODY>
</HTML>


