/* Menu.c */
#include <stdio.h>
#include <gtk/gtk.h>

gboolean CallBack(GtkWidget *menu_entry, gchar *texte)
{
  printf("%s\n", texte);
  return TRUE;
}

void main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *MenuBar;
  GtkWidget *Menu;
  GtkWidget *MenuItem;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre de dialogue */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  /* Connection des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit,
                     NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit,
                     NULL);
  /* Cration et attachement de la barre de menus */
  MenuBar = gtk_menu_bar_new();
  gtk_container_add(GTK_CONTAINER(Fenetre), MenuBar);
  /* Cration et attachement de la premire entre */
  MenuItem = gtk_menu_item_new_with_label("Fichier");
  gtk_menu_bar_append(GTK_MENU_BAR(MenuBar), MenuItem);
  gtk_signal_connect(GTK_OBJECT(MenuItem), "activate",
                     (GtkSignalFunc)CallBack,
                     (gpointer)"Menu Fichier");
    /* Cration du menu associ  l'entre "Fichier" */
    Menu = gtk_menu_new();
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(MenuItem), 
                              Menu);
    /* L'entre "Ouvrir" */
    MenuItem = gtk_menu_item_new_with_label("Ouvrir");
    gtk_menu_append(GTK_MENU(Menu), MenuItem);
    /* L'entre "Nouveau" */
    MenuItem = gtk_menu_item_new_with_label("Nouveau");
    gtk_menu_append(GTK_MENU(Menu), MenuItem);
    /* Un sparateur */
    MenuItem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(Menu), MenuItem);
    /* L'entre "Quitter" */
    MenuItem = gtk_menu_item_new_with_label("Quitter");
    gtk_menu_append(GTK_MENU(Menu), MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem), "activate",
                       (GtkSignalFunc)gtk_exit, NULL);
  /* Cration et attachement de la deuxime entre */
  MenuItem = gtk_menu_item_new_with_label("Edition");
  gtk_menu_bar_append(GTK_MENU_BAR(MenuBar), MenuItem);
  gtk_signal_connect(GTK_OBJECT(MenuItem), "activate",
                     (GtkSignalFunc)CallBack,
                     (gpointer)"Menu Edition");
    /* Cration du menu associ  l'entre "Edition" */
    Menu = gtk_menu_new();
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(MenuItem), 
                              Menu);
    /* L'entre "Sous-menu" */
    MenuItem = gtk_menu_item_new_with_label("Sous-menu");
    gtk_menu_append(GTK_MENU(Menu), MenuItem);
      /* Cration du sous-menu associ
       *  l'entre "Sous-menu" */
      Menu = gtk_menu_new();
      gtk_menu_item_set_submenu(GTK_MENU_ITEM(MenuItem), 
                                Menu);
      /* L'entre "Entree" */
      MenuItem = gtk_menu_item_new_with_label("Entree");
      gtk_menu_append(GTK_MENU(Menu), MenuItem);
    
  /* Cration et attachement de la dernire entre */
  MenuItem = gtk_menu_item_new_with_label("Aide");
  gtk_menu_bar_append(GTK_MENU_BAR(MenuBar), MenuItem);
  gtk_signal_connect(GTK_OBJECT(MenuItem), "activate",
                     (GtkSignalFunc)CallBack,
                     (gpointer)"Menu Aide");
  gtk_menu_item_right_justify(GTK_MENU_ITEM(MenuItem));

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);      

  /* La boucle principale */
  gtk_main();
}
