/* Popup.c */
#include <stdio.h>
#include <gtk/gtk.h>

gboolean CallBack(GtkWidget *menu_entry, gchar *texte)
{
  printf("%s\n", texte);
  return TRUE;
}

gboolean PopMenu(GtkMenu *Menu, GdkEvent *ev)
{
  if (ev->type == GDK_BUTTON_PRESS)
  { /* L'vnement est bien un appui sur un bouton */
    GdkEventButton *bev = (GdkEventButton *)ev;
    if (bev->button == 3) /* Est-ce le bouton droit ? */
    {
      gtk_menu_popup(Menu, NULL, NULL, NULL, NULL,
                     bev->button, bev->time);
      /* Signalons que nous avons trait cet vnement */
      return TRUE;
    }
  }
  /* Sinon, on signale que l'on n'a pas
   * trait cet vnement */
  return FALSE;
}

void main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *Bouton;
  GtkWidget *Menu;
  GtkWidget *MenuItem;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 5);
  /* Connection des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit,
                     NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit,
                     NULL);
  /* Cration du menu  */
  Menu = gtk_menu_new();
  /* L'entre "Ouvrir" */
  MenuItem = gtk_menu_item_new_with_label("Ouvrir");
  gtk_menu_append(GTK_MENU(Menu), MenuItem);
  gtk_signal_connect(GTK_OBJECT(MenuItem), "activate",
                     (GtkSignalFunc)CallBack,
                     (gpointer)"Ouvrir");
  gtk_widget_show(MenuItem);
  /* L'entre "Nouveau" */
  MenuItem = gtk_menu_item_new_with_label("Nouveau");
  gtk_menu_append(GTK_MENU(Menu), MenuItem);
  gtk_signal_connect(GTK_OBJECT(MenuItem), "activate",
                     (GtkSignalFunc)CallBack,
                     (gpointer)"Nouveau");
  gtk_widget_show(MenuItem);
  /* Un sparateur */
  MenuItem = gtk_menu_item_new();
  gtk_menu_append(GTK_MENU(Menu), MenuItem);
  gtk_widget_show(MenuItem);
  /* L'entre "Quitter" */
  MenuItem = gtk_menu_item_new_with_label("Quitter");
  gtk_menu_append(GTK_MENU(Menu), MenuItem);
  gtk_signal_connect(GTK_OBJECT(MenuItem), "activate",
                       (GtkSignalFunc)gtk_exit, NULL);
  gtk_widget_show(MenuItem);
  /* Le bouton */
  Bouton = gtk_button_new_with_label("Popup");
  gtk_container_add(GTK_CONTAINER(Fenetre), Bouton);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "event",
                            (GtkSignalFunc)PopMenu,
                            GTK_OBJECT(Menu));
     
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);      

  /* La boucle principale */
  gtk_main();
}
