/* Combo.c */
#include <stdio.h>
#include <gtk/gtk.h>

gboolean CallBackOK(GtkWidget *Bouton, GtkWidget **Combo)
{
  GtkEntry *Entry;

  Entry = GTK_ENTRY(GTK_COMBO(Combo[0])->entry);
  printf("Fruit   : %s\n", gtk_entry_get_text(Entry));
  Entry = GTK_ENTRY(GTK_COMBO(Combo[1])->entry);
  printf("Couleur : %s\n", gtk_entry_get_text(Entry));
  return TRUE;
}

gboolean FinDialogue(GtkWidget *Dialogue,
                     GtkWidget **Entries)
{
  g_free(Entries);
  gtk_exit(0);
  return FALSE;
}

void main(int argc, char *argv[])
{
  GtkWidget *Dialogue;
  GtkWidget *Bouton;
  GtkWidget *Table;
  GtkWidget *Label;
  GtkWidget *Combo;
  GtkWidget **Combos;
  GList *liste;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Le tableau Combos contiendra des pointeurs
   * sur les deux GtkCombos du dialogue */
  Combos = g_malloc(2*sizeof(GtkWidget *));
  /* Cration de la fentre de dialogue */
  Dialogue = gtk_dialog_new();
  /* Le titre de la fentre de dialogue */
  gtk_window_set_title(GTK_WINDOW(Dialogue),
                       "Test GtkCombo");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Dialogue), "delete_event",
                     (GtkSignalFunc)FinDialogue,
                     (gpointer)Combos);
  gtk_signal_connect(GTK_OBJECT(Dialogue), "destroy",
                     (GtkSignalFunc)FinDialogue,
                     (gpointer)Combos);

  /* Le corps de la bote de dialogue est occup
   * par une table */
  Table = gtk_table_new(2, 2, FALSE);
  gtk_box_pack_start_defaults(
                GTK_BOX(GTK_DIALOG(Dialogue)->vbox),
                Table);
  
    /* Le label "Fruit" */
    Label = gtk_label_new("  Fruit :  ");
    gtk_table_attach_defaults(GTK_TABLE(Table), Label,
                              0,1, 0,1);
    /* Le GtkCombo pour les fruits */
    Combo = gtk_combo_new();
    Combos[0] = Combo;
    gtk_table_attach_defaults(GTK_TABLE(Table), Combo,
                              1,2, 0,1);
    /* On remplit la liste des fruits ... */
    liste = NULL;
    liste = g_list_append(liste, "Banane");
    liste = g_list_append(liste, "Pomme");
    liste = g_list_append(liste, "Poire");
    /* et on la place dans la combo : */
    gtk_combo_set_popdown_strings(GTK_COMBO(Combo), liste);
 
    /* Le label "Couleur" */
    Label = gtk_label_new("Couleur :");
    gtk_table_attach_defaults(GTK_TABLE(Table), Label,
                              0,1, 1,2);
    /* Le GtkCombo pour la couleur */
    Combo = gtk_combo_new();
    Combos[1] = Combo;
    gtk_table_attach_defaults(GTK_TABLE(Table), Combo,
                              1,2, 1,2);
    /* On remplit la liste des couleurs ... */
    liste = NULL;
    liste = g_list_append(liste, "Bleu");
    liste = g_list_append(liste, "Vert");
    liste = g_list_append(liste, "Rouge");
    /* et on la place dans la combo : */
    gtk_combo_set_popdown_strings(GTK_COMBO(Combo), liste);
    /* Les flches permettent toujours de choisir
     * dans cette liste... */
    gtk_combo_set_use_arrows_always(GTK_COMBO(Combo), TRUE);
 
  /* Les boutons de la bote de dialogue */
  /* Le bouton OK */
  Bouton = gtk_button_new_with_label("OK");
  gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)CallBackOK,
                     (gpointer)Combos);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                           (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_box_pack_start(
                GTK_BOX(GTK_DIALOG(Dialogue)->action_area),
                Bouton, TRUE, TRUE, 0);
  gtk_widget_grab_default(Bouton);
  /* Le bouton Annuler */
  Bouton = gtk_button_new_with_label("Annuler");
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                           (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_box_pack_start(
                GTK_BOX(GTK_DIALOG(Dialogue)->action_area),
                Bouton, TRUE, TRUE, 0);

  /* On affiche le tout */
  gtk_widget_show_all(Dialogue);      

  /* La boucle principale */
  gtk_main();
}
