/* Entry.c */
#include <stdio.h>
#include <gtk/gtk.h>

gboolean CallBackOK(GtkWidget *Bouton, GtkWidget **Entries)
{
  printf("Nom          : %s\n",
         gtk_entry_get_text(GTK_ENTRY(Entries[0])));
  
  printf("Mot de passe : %s\n",
         gtk_entry_get_text(GTK_ENTRY(Entries[1])));
  return TRUE;
}

gboolean FinDialogue(GtkWidget *Dialogue,
                     GtkWidget **Entries)
{
  g_free(Entries);
  gtk_exit(0);
  return FALSE;
}

void main(int argc, char *argv[])
{
  GtkWidget *Dialogue;
  GtkWidget *Bouton;
  GtkWidget *Table;
  GtkWidget *Label;
  GtkWidget *Entry;
  GtkWidget **Entries;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Le tableau Entries contiendra des pointeurs
   * sur les deux GtkEntries du dialogue */
  Entries = g_malloc(2*sizeof(GtkWidget *));
  /* Cration de la fentre de dialogue */
  Dialogue = gtk_dialog_new();
  /* Le titre de la fentre de dialogue */
  gtk_window_set_title(GTK_WINDOW(Dialogue),
                       "Test GtkEntry");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Dialogue), "delete_event",
                     (GtkSignalFunc)FinDialogue,
                     (gpointer)Entries);
  gtk_signal_connect(GTK_OBJECT(Dialogue), "destroy",
                     (GtkSignalFunc)FinDialogue,
                     (gpointer)Entries);

  /* Le corps de la bote de dialogue est occup
   * par une table */
  Table = gtk_table_new(2, 2, TRUE);
  gtk_box_pack_start_defaults(
                GTK_BOX(GTK_DIALOG(Dialogue)->vbox),
                Table);
  
    /* Le label "Nom" */
    Label = gtk_label_new("  Nom :  ");
    gtk_table_attach_defaults(GTK_TABLE(Table), Label,
                              0,1, 0,1);
    /* Le GtkEntry pour le nom */
    Entry = gtk_entry_new();
    Entries[0] = Entry;
    gtk_table_attach_defaults(GTK_TABLE(Table), Entry,
                              1,2, 0,1);

    /* Le label "Mot de passe" */
    Label = gtk_label_new("Mot de passe :");
    gtk_table_attach_defaults(GTK_TABLE(Table), Label,
                              0,1, 1,2);
    /* Le GtkEntry pour le mot de passe */
    Entry = gtk_entry_new_with_max_length(8);
    Entries[1] = Entry;
    gtk_entry_set_visibility(GTK_ENTRY(Entry), FALSE);
    gtk_table_attach_defaults(GTK_TABLE(Table), Entry,
                              1,2, 1,2);
  
    /* Les boutons de la bote de dialogue */
  
  /* Le bouton OK */
  Bouton = gtk_button_new_with_label("OK");
  gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)CallBackOK,
                     (gpointer)Entries);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                           (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_box_pack_start(
                GTK_BOX(GTK_DIALOG(Dialogue)->action_area),
                Bouton, TRUE, TRUE, 0);
  gtk_widget_grab_default(Bouton);
  /* Le bouton Annuler */
  Bouton = gtk_button_new_with_label("Annuler");
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                           (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_box_pack_start(
                GTK_BOX(GTK_DIALOG(Dialogue)->action_area),
                Bouton, TRUE, TRUE, 0);

  /* On affiche le tout */
  gtk_widget_show_all(Dialogue);      

  /* La boucle principale */
  gtk_main();
}
