/* Text.c */
#include <stdio.h>
#include <gtk/gtk.h>

static gchar *NomFichier;

/* Fonction de rappel associe au 
 * bouton "Sauvegarde"
 */
gboolean SauveTexte(GtkText *Texte)
{
  FILE *Fichier;

  Fichier = fopen(NomFichier, "w");
  if (Fichier)
  {
    gchar *Tampon;
    /* On rcupre le texte */
    Tampon = gtk_editable_get_chars(GTK_EDITABLE(Texte),
                                    0, -1);
    /* Et on le sauvegarde */
    fwrite(Tampon,
           gtk_text_get_length(Texte), 1,
           Fichier);
    fclose(Fichier);
  }
  return TRUE;
}

gboolean FinDialogue(GtkWidget *Dialogue)
{
  gtk_exit(0);
  return FALSE;
}

void LitFichier(GtkWidget *Texte)
{
  FILE *Fichier;

  /* On gle momentanment l'affichage du GtkText */
  gtk_text_freeze(GTK_TEXT(Texte));

  Fichier = fopen(NomFichier, "r");

  if (Fichier)
  {
    char *Tampon;
    int TailleLu, TailleTampon, ret;
    TailleLu = 0;
    TailleTampon = 1024;
    Tampon = g_malloc(TailleTampon);
    do 
    {
      if (TailleTampon < TailleLu + 1024)
      {
        TailleTampon *= 2;
        Tampon = g_realloc(Tampon, TailleTampon);
      }
      ret = fread(Tampon + TailleLu, 1, 1024, Fichier);
      TailleLu += ret;
      if (ret < 1024)
        break;
    } while (ret >= 1024);
    
    gtk_text_insert(GTK_TEXT(Texte),
                    NULL, NULL,
                    NULL,
                    Tampon, TailleLu);
    g_free(Tampon);
    fclose(Fichier);
  }
  /* On rtablit l'affichage du GtkText */
  gtk_text_thaw(GTK_TEXT(Texte));
}

void main(int argc, char *argv[])
{
  GtkWidget *Dialogue;
  GtkWidget *Bouton;
  GtkWidget *Texte;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre de dialogue */
  Dialogue = gtk_dialog_new();
  /* Le titre de la fentre de dialogue */
  gtk_window_set_title(GTK_WINDOW(Dialogue),
                       "Test Texte");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Dialogue), "delete_event",
                     (GtkSignalFunc)FinDialogue,
                     NULL);
  gtk_signal_connect(GTK_OBJECT(Dialogue), "destroy",
                     (GtkSignalFunc)FinDialogue,
                     NULL);

  /* Le corps de la bote de dialogue est occup 
   * par un GtkText */
  Texte = gtk_text_new(NULL, NULL);
  gtk_text_set_editable(GTK_TEXT(Texte), TRUE);
  /* Lecture du fichier pass en paramtre */
  NomFichier = argv[1];
  LitFichier(Texte);
  gtk_box_pack_start_defaults(
                GTK_BOX(GTK_DIALOG(Dialogue)->vbox),
                Texte);

  /* Les boutons de la bote de dialogue */
  
  /* Le bouton "Sauvegarde" */
  Bouton = gtk_button_new_with_label("Sauvegarde");
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)SauveTexte,
                     GTK_OBJECT(Texte));
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                           (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_box_pack_start(
                GTK_BOX(GTK_DIALOG(Dialogue)->action_area),
                Bouton, TRUE, TRUE, 0);
  gtk_widget_grab_default(Bouton);
  /* Le bouton Annuler */
  Bouton = gtk_button_new_with_label("Annuler");
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                           (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_box_pack_start(
                GTK_BOX(GTK_DIALOG(Dialogue)->action_area),
                Bouton, TRUE, TRUE, 0);

  /* On affiche le tout */
  gtk_widget_show_all(Dialogue);      

  /* La boucle principale */
  gtk_main();
}
