/* Ascenseur.c */
#include <stdio.h>
#include <gtk/gtk.h>

void main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *Boite;
  GtkWidget *Ascenseur;
  GtkWidget *Texte;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Ascenseur");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* La bote horizontale qui contiendra 
   * le texte et l'ascenseur */
  Boite = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(Fenetre), Boite);

  /* Le texte */
  Texte = gtk_text_new(NULL, NULL);
  gtk_text_set_editable(GTK_TEXT(Texte), TRUE);
  gtk_box_pack_start_defaults(GTK_BOX(Boite), Texte);
  /* L'ascenseur */
  Ascenseur = gtk_vscrollbar_new(GTK_TEXT(Texte)->vadj);
  gtk_box_pack_start_defaults(GTK_BOX(Boite), Ascenseur);

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
}
