/* Cadre.c */
#include <gtk/gtk.h>

void main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *Cadre;
  GtkWidget *Boite;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* La fentre principale */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 5);
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* Le cadre englobant les deux autres */
  Cadre = gtk_frame_new("Milieu");
  gtk_container_add(GTK_CONTAINER(Fenetre), Cadre);
  gtk_frame_set_label_align(GTK_FRAME(Cadre), 0.5, 0.5);
  /* Cration d'une bote horizontale qui contiendra les
   * deux autres cadres */
  Boite = gtk_hbox_new(TRUE, 5);
  gtk_container_add(GTK_CONTAINER(Cadre), Boite);
  gtk_container_set_border_width(GTK_CONTAINER(Boite), 5);
  /* Le cadre de gauche */
  Cadre = gtk_frame_new("Gauche");
  gtk_box_pack_start_defaults(GTK_BOX(Boite), Cadre);
  gtk_frame_set_label_align(GTK_FRAME(Cadre), 0.0, 0.5);
  /* Le cadre de droite */
  Cadre = gtk_frame_new("Droite");
  gtk_box_pack_start_defaults(GTK_BOX(Boite), Cadre);
  gtk_frame_set_label_align(GTK_FRAME(Cadre), 1.0, 0.5);
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
}
