/* Jauge.c */
#include <stdio.h>
#include <gtk/gtk.h>

gboolean CallBackOK(GtkWidget *Bouton, GtkAdjustment *adj)
{
  printf("Valeur : %g\n", adj->value);
  return TRUE;
}

void main(int argc, char *argv[])
{
  GtkWidget *Dialogue;
  GtkWidget *Bouton;
  GtkWidget *Boite;
  GtkObject *adj;
  GtkWidget *Jauge;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre de dialogue */
  Dialogue = gtk_dialog_new();
  /* Le titre de la fentre de dialogue */
  gtk_window_set_title(GTK_WINDOW(Dialogue), "Test Jauge");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Dialogue), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Dialogue), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* Le corps de la bote de dialogue est occup
   * par une bote horizontale */
  Boite = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start_defaults(
                GTK_BOX(GTK_DIALOG(Dialogue)->vbox),
                Boite);

  /* Cration de l'ajustement commun */
  adj = gtk_adjustment_new(50.0, 0.0, 100.0, 1.0, 5.0, 1.0);
  /* La jauge horizontale */
  Jauge = gtk_hscale_new(GTK_ADJUSTMENT(adj));
  gtk_box_pack_start(GTK_BOX(Boite), Jauge, TRUE, TRUE, 10);
  /* On veut 3 chiffres aprs la virgule */
  gtk_scale_set_digits(GTK_SCALE(Jauge), 3);
  /* On place la valeur en dessous de la jauge */
  gtk_scale_set_value_pos(GTK_SCALE(Jauge), GTK_POS_BOTTOM);
  

  /* La jauge verticale */
  Jauge = gtk_vscale_new(GTK_ADJUSTMENT(adj));
  gtk_box_pack_start(GTK_BOX(Boite), Jauge, TRUE, TRUE, 10);
  /* La valeur n'est pas affiche pour la jauge verticale */
  gtk_scale_set_draw_value(GTK_SCALE(Jauge), FALSE);
  
  /* Le bouton OK */
  Bouton = gtk_button_new_with_label("OK");
  gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)CallBackOK,
                     (gpointer)adj);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                           (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_box_pack_start(
                GTK_BOX(GTK_DIALOG(Dialogue)->action_area),
                Bouton, TRUE, TRUE, 0);
  gtk_widget_grab_default(Bouton);
  /* Le bouton Annuler */
  Bouton = gtk_button_new_with_label("Annuler");
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                           (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_box_pack_start(
                GTK_BOX(GTK_DIALOG(Dialogue)->action_area),
                Bouton, TRUE, TRUE, 0);

  /* On affiche le tout */
  gtk_widget_show_all(Dialogue);      

  /* La boucle principale */
  gtk_main();
}
