/* Rulers.c */
#include <gtk/gtk.h>

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Table;
  GtkWidget *Reglet_H;
  GtkWidget *Reglet_V;
  GtkWidget *EventBox;
  GtkWidgetClass *Classe;
  GtkSignalFunc fonction;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Test Reglets");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /*  Cration de la table */
  Table = gtk_table_new(2, 2, FALSE);
  gtk_container_add(GTK_CONTAINER(Fenetre), Table);      

  /* Le rglet horizontal */
  Reglet_H = gtk_hruler_new();
  gtk_ruler_set_metric(GTK_RULER(Reglet_H), GTK_INCHES);
  gtk_ruler_set_range(GTK_RULER(Reglet_H), 150, 250, 0, 250);
  gtk_table_attach(GTK_TABLE(Table), Reglet_H,
                   1,2, 0,1,
                   GTK_FILL | GTK_EXPAND, GTK_FILL,
                   0, 0);
  
  /* Le rglet vertical */
  Reglet_V = gtk_vruler_new();
  gtk_ruler_set_range(GTK_RULER(Reglet_V), 0, 50, 0, 50);
  gtk_table_attach(GTK_TABLE(Table), Reglet_V,
                   0,1, 1,2,
                   GTK_FILL, GTK_FILL | GTK_EXPAND,
                   0, 0);

  /* L'event box */
  EventBox = gtk_event_box_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), EventBox,
                            1,2, 1,2);
  gtk_widget_set_usize(EventBox, 150, 150);
  gtk_widget_add_events(EventBox, GDK_POINTER_MOTION_MASK);
  /* Connexion du signal "motion_notify_event"
   * pour le rglet horizontal */
  Classe = GTK_WIDGET_CLASS(GTK_OBJECT(Reglet_H)->klass);
  fonction = (GtkSignalFunc)(Classe->motion_notify_event);
  gtk_signal_connect_object(GTK_OBJECT(EventBox),
                            "motion_notify_event",
                            fonction,
                            GTK_OBJECT(Reglet_H));
  /* Connexion du signal "motion_notify_event"
   * pour le rglet vertical */
  Classe = GTK_WIDGET_CLASS(GTK_OBJECT(Reglet_V)->klass);
  fonction = (GtkSignalFunc)(Classe->motion_notify_event);
  gtk_signal_connect_object(GTK_OBJECT(EventBox),
                            "motion_notify_event",
                            fonction,
                            GTK_OBJECT(Reglet_V));

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
