/* Layout.c */
#include <gtk/gtk.h>

void main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *Scr;
  GtkWidget *Layout;
  int i,j;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Test Layout");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* Le GtkScrolledWindow */
  Scr = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add(GTK_CONTAINER(Fenetre), Scr);
  /*  Cration du layout */
  Layout = gtk_layout_new(NULL, NULL);
  gtk_layout_set_size(GTK_LAYOUT(Layout), 10000, 10000);
  gtk_container_add(GTK_CONTAINER(Scr), Layout);

  /* On gle momentanment l'affichage du layout */
  gtk_layout_freeze(GTK_LAYOUT(Layout));
  
  /* On place 10x10 boutons dans le layout, 
   * chacun spar de ses voisins de 1000 pixels,
   * on a donc une fentre de 10.000 par 10.000 ! */
  for (i=0 ; i<10 ; i++)
    for (j=0 ; j<10 ; j++)
    {
      GtkWidget *Bouton;
      gchar *label;
      
      label = g_strdup_printf("Bouton (%d, %d)", i,j);
      Bouton = gtk_button_new_with_label(label);
      g_free(label);
      gtk_layout_put(GTK_LAYOUT(Layout), Bouton, 
                     i*1000, j*1000);
    }
  
  /* On rtablit l'affichage du layout : */
  gtk_layout_thaw(GTK_LAYOUT(Layout));
  
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
}
