/* CList.c */
#include <gtk/gtk.h>

static gchar *Titres[] = 
{
  "Gauche", "Droite", "Milieu",
  "Taille fixe", "Colone 4", "Colonne 5"
};

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Scr;
  GtkWidget *clist;
  gint i;
  gchar *Textes[6];
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Test GtkCList");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /*  Cration du GtkScrolledWindow */
  Scr = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(Fenetre), Scr);      
  gtk_widget_set_usize(Scr, 150, 100);

  /* Cration du GtkCList */
  clist = gtk_clist_new_with_titles(6, Titres);
  gtk_container_add(GTK_CONTAINER(Scr), clist);
  /* Changement des proprits des colonnes */
  gtk_clist_set_reorderable(GTK_CLIST(clist), TRUE);
  for (i=0 ; i<6 ; i++)
      gtk_clist_set_column_width(GTK_CLIST(clist), i, 80);
  gtk_clist_set_column_justification(GTK_CLIST(clist), 0,
                                     GTK_JUSTIFY_LEFT);
  gtk_clist_set_column_justification(GTK_CLIST(clist), 1,
                                     GTK_JUSTIFY_RIGHT);
  gtk_clist_set_column_justification(GTK_CLIST(clist), 2,
                                     GTK_JUSTIFY_CENTER);
  gtk_clist_set_column_resizeable(GTK_CLIST(clist), 3,
                                  FALSE);
  /* Remplissage du GtkCList */
  gtk_clist_freeze(GTK_CLIST(clist));
  for (i=0 ; i<100 ; i++)
  {
    int j;
    Textes[0] = g_strdup_printf("ligne %d", i);
    Textes[1] = g_strdup("Droite");
    Textes[2] = g_strdup("Centre");
    Textes[3] = g_strdup("fixe");
    Textes[4] = g_strdup("colonne 4");
    Textes[5] = g_strdup("colonne 5");
    gtk_clist_append(GTK_CLIST(clist), Textes);
    for (j=0 ; j<6 ; j++)
      g_free(Textes[j]);
  }
  gtk_clist_thaw(GTK_CLIST(clist));

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
