/* CTree.c */
#include <gtk/gtk.h>

/* Les images xpms */
static char *livre_ouvert_xpm[] =
{
  "16 16 4 1",
  "       c None s None",
  ".      c black",
  "X      c #808080",
  "o      c white",
  "                ",
  "  ..            ",
  " .Xo.    ...    ",
  " .Xoo. ..oo.    ",
  " .Xooo.Xooo...  ",
  " .Xooo.oooo.X.  ",
  " .Xooo.Xooo.X.  ",
  " .Xooo.oooo.X.  ",
  " .Xooo.Xooo.X.  ",
  " .Xooo.oooo.X.  ",
  "  .Xoo.Xoo..X.  ",
  "   .Xo.o..ooX.  ",
  "    .X..XXXXX.  ",
  "    ..X.......  ",
  "     ..         ",
  "                "
};

static char *livre_ferme_xpm[] =
{
  "16 16 6 1",
  "       c None s None",
  ".      c black",
  "X      c red",
  "o      c yellow",
  "O      c #808080",
  "#      c white",
  "                ",
  "       ..       ",
  "     ..XX.      ",
  "   ..XXXXX.     ",
  " ..XXXXXXXX.    ",
  ".ooXXXXXXXXX.   ",
  "..ooXXXXXXXXX.  ",
  ".X.ooXXXXXXXXX. ",
  ".XX.ooXXXXXX..  ",
  " .XX.ooXXX..#O  ",
  "  .XX.oo..##OO. ",
  "   .XX..##OO..  ",
  "    .X.#OO..    ",
  "     ..O..      ",
  "      ..        ",
  "                "
};

static char *feuille_xpm[] =
{
  "16 16 4 1",
  "       c None s None",
  ".      c black",
  "X      c white",
  "o      c #808080",
  "                ",
  "   .......      ",
  "   .XXXXX..     ",
  "   .XoooX.X.    ",
  "   .XXXXX....   ",
  "   .XooooXoo.o  ",
  "   .XXXXXXXX.o  ",
  "   .XooooooX.o  ",
  "   .XXXXXXXX.o  ",
  "   .XooooooX.o  ",
  "   .XXXXXXXX.o  ",
  "   .XooooooX.o  ",
  "   .XXXXXXXX.o  ",
  "   ..........o  ",
  "    oooooooooo  ",
  "                "
};

static gchar *Titres[] = 
{
  "arborescence", "Info"
};

GdkPixmap *pixmap_ouvert;
GdkPixmap *pixmap_ferme;
GdkPixmap *pixmap_feuille;
GdkBitmap *masque_ouvert;
GdkBitmap *masque_ferme;
GdkBitmap *masque_feuille;

void CreeArbre(GtkCTree *arbre, GtkCTreeNode *parent,
               GtkCTreeNode *frere, int profondeur,
               int largeur)
{
  GtkCTreeNode *noeud;
  gchar *textes[2];
  static index_noeud = 0;
  static index_feuille = 0;

  if (largeur > 3)
    return;
  if (profondeur < 3)
  {
    textes[0] = g_strdup_printf("noeud %d", index_noeud++);
    textes[1] = g_strdup_printf("(%d, %d)", 
                                profondeur, largeur);
    noeud = gtk_ctree_insert_node(arbre, parent, frere,
                                  textes, 5,
                                  pixmap_ouvert,
                                  masque_ouvert,
                                  pixmap_ferme, 
                                  masque_ferme,
                                  FALSE, FALSE); 
    g_free(textes[0]); g_free(textes[1]);
    CreeArbre(arbre, noeud, NULL, profondeur+1, 0);
  } else
  {
    textes[0] = g_strdup_printf("feuille %d",
                                index_feuille++);
    textes[1] = g_strdup_printf("(%d, %d)",
                                profondeur, largeur);
    noeud = gtk_ctree_insert_node(arbre, parent, frere,
                                  textes, 5,
                                  pixmap_feuille,
                                  masque_feuille,
                                  NULL, NULL,
                                  TRUE, FALSE);
    g_free(textes[0]); g_free(textes[1]);
  }
  CreeArbre(arbre, parent, noeud, profondeur, largeur+1);
}

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Scr;
  GtkWidget *ctree;
  GdkColor transparent;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Test GtkCTree");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /*  Cration du GtkScrolledWindow */
  Scr = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(Fenetre), Scr);      
  gtk_widget_set_usize(Scr, 150, 100);

  /* Cration du GtkCTree */
  ctree = gtk_ctree_new_with_titles(2, 0, Titres);
  gtk_container_add(GTK_CONTAINER(Scr), ctree);
  
  /* Cration des pixmaps */
  gtk_widget_realize(Fenetre);
  pixmap_ouvert = gdk_pixmap_create_from_xpm_d(
                          Fenetre->window, 
                          &masque_ouvert,
                          &transparent, 
                          livre_ferme_xpm);
  pixmap_ferme = gdk_pixmap_create_from_xpm_d(
                          Fenetre->window,
                          &masque_ferme,
                          &transparent,
                          livre_ouvert_xpm);
  pixmap_feuille = gdk_pixmap_create_from_xpm_d(
                          Fenetre->window,
                          &masque_feuille,
                          &transparent, 
                          feuille_xpm);
                  
  /* Configuration de l'arbre */
  gtk_ctree_set_line_style(GTK_CTREE(ctree),
                           GTK_CTREE_LINES_DOTTED);
  gtk_ctree_set_expander_style(GTK_CTREE(ctree),
                               GTK_CTREE_EXPANDER_CIRCULAR);
  gtk_clist_set_row_height(GTK_CLIST(ctree), 20);
  /* Remplissage de l'arbre */
  CreeArbre(GTK_CTREE(ctree), NULL, NULL, 0, 0);

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
