/* Liste.c */
#include        <stdio.h>
#include        <gtk/gtk.h>

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Scr;
  GtkWidget *gtklist;
  GtkWidget *Element;
  GList *Liste = NULL;
  int i;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Test GtkList");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /*  Cration du GtkScrolledWindow */
  Scr = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(Fenetre), Scr);      
  gtk_widget_set_usize(Scr, 150, 100);

  /* Cration du GtkList */
  gtklist = gtk_list_new();
  gtk_scrolled_window_add_with_viewport(
                         GTK_SCROLLED_WINDOW(Scr), gtklist);
   
  /* Cration de 10 lments en utilisant une GList */
  for (i=0 ; i<10 ; i++)
  {
    gchar *label;

    label = g_strdup_printf("lment GList %d", i);
    Element = gtk_list_item_new_with_label(label);
    g_free(label);
    Liste = g_list_append(Liste, Element);
  }
  gtk_list_append_items(GTK_LIST(gtklist), Liste);
  /* Cration de 10 lments contenant des boutons */
  for (i=0 ; i<10 ; i++)
  {
    gchar *label;
    GtkWidget *Bouton;

    label = g_strdup_printf("lment direct %d", i);
    Bouton = gtk_button_new_with_label(label);
    g_free(label);
    Element = gtk_list_item_new();
    gtk_container_add(GTK_CONTAINER(Element), Bouton);
    gtk_container_add(GTK_CONTAINER(gtklist), Element);
  }

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
