/* Notebook.c */
#include <gtk/gtk.h>

static void AjoutePage(GtkNotebook *notebook, int numero)
{
  GtkWidget *Frame;
  GtkWidget *LabelOnglet;
  gchar *TexteOnglet;
  GtkWidget *LabelMenu;
  gchar *TexteMenu;
  GtkWidget *Label;
  gchar *Texte;

  Frame = gtk_frame_new("");
  gtk_container_set_border_width(GTK_CONTAINER(Frame), 10);
  gtk_widget_set_usize(Frame, 150,100);

  TexteOnglet = g_strdup_printf("Onglet %d", numero);
  LabelOnglet = gtk_label_new(TexteOnglet);
  g_free(TexteOnglet);

  TexteMenu = g_strdup_printf("Menu %d", numero);
  LabelMenu = gtk_label_new(TexteMenu);
  g_free(TexteMenu);

  gtk_notebook_append_page_menu(notebook, Frame,
                                LabelOnglet,
                                LabelMenu);
  Texte = g_strdup_printf("Page %d", numero);
  Label = gtk_label_new(Texte);
  g_free(Texte);
  gtk_container_add(GTK_CONTAINER(Frame), Label);
}

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Notebook;
  gint i;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Test Notebook");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /*  Cration du GtkNotebook */
  Notebook = gtk_notebook_new();;
  gtk_container_add(GTK_CONTAINER(Fenetre), Notebook);      

  /* Configuration du notebook */
  gtk_notebook_popup_enable(GTK_NOTEBOOK(Notebook));
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(Notebook),
                           GTK_POS_RIGHT);
  gtk_notebook_set_scrollable(GTK_NOTEBOOK(Notebook), TRUE);
  
  /* Ajout des pages au notebook */
  for (i=1 ; i<=9 ; i++)
    AjoutePage(GTK_NOTEBOOK(Notebook), i);

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
 
