/* DrawingArea.c */
#include <gtk/gtk.h>

gboolean Dessine(GtkWidget *ZoneDessin, GdkEventExpose *ev)
{
  GdkColor gdk_color;
  GdkColormap *colormap;
  GdkGC *gc;
  int i;

  /* On rcupre la colormap de la zone de dessin */
  colormap = gdk_window_get_colormap(ZoneDessin->window);
  /* On cre la couleur blanche */
  gdk_color.red = 65535;
  gdk_color.green = 65535;
  gdk_color.blue = 65535;
  gdk_color_alloc(colormap, &gdk_color);
  /* On rend le fond de la fentre blanc */
  gdk_window_set_background(ZoneDessin->window, &gdk_color);
  
  /* On rcupre le GC par dfaut de la fentre */
  gc = gdk_gc_new(ZoneDessin->window);
  
  /* On alloue la couleur bleue */
  gdk_color.red = 0;
  gdk_color.green = 0;
  gdk_color.blue = 65535;
  gdk_color_alloc(colormap, &gdk_color);
  /* La couleur bleue nous servira pour dessiner */
  gdk_gc_set_foreground(gc, &gdk_color);
          
  /* On trace des lignes dans la zone de dessin */
  for (i=0 ; i<ZoneDessin->allocation.width ; i+=5)
    gdk_draw_line(ZoneDessin->window, gc, i,0,
                  ZoneDessin->allocation.width-i,
                  ZoneDessin->allocation.height);
  for (i=0 ; i<ZoneDessin->allocation.height ; i+=5)
    gdk_draw_line(ZoneDessin->window, gc, 
                  0,ZoneDessin->allocation.height-i,
                  ZoneDessin->allocation.width, i);
  
  /* On dtruit le GC dont on n'a plus besoin */
  gdk_gc_destroy(gc);
  return TRUE;
}

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *ZoneDessin;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(Fenetre),
                       "Test Drawing Area");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);
  /* Cration et attachement de la zone de 
   * dessin dans la fentre */
  ZoneDessin = gtk_drawing_area_new();
  gtk_container_add(GTK_CONTAINER(Fenetre), ZoneDessin);
  gtk_drawing_area_size(GTK_DRAWING_AREA(ZoneDessin), 
                        150, 150);
  /* Connexion du signal "expose_event" */
  gtk_signal_connect(GTK_OBJECT(ZoneDessin), "expose_event",
                     (GtkSignalFunc)Dessine, NULL);
  /* On affiche le dialogue */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
