/* Calendrier.c */
#include <stdio.h>
#include <gtk/gtk.h>

gboolean AfficheDate(GtkCalendar *Calendrier)
{
  guint jour, mois, annee;
  gchar *NomMois[] = {"janvier", "fvrier", "mars", "avril",
                      "mai", "juin", "juillet", "aot",
                      "septembre", "octobre", "novembre",
                      "dcembre" };

  gtk_calendar_get_date(Calendrier,
                        &annee, &mois, &jour);
  printf("Date slectionne : %d %s %d\n", 
         jour, NomMois[mois], annee);
  return TRUE;
}

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Calendrier;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(Fenetre),
                       "Test Calendrier");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);
  /* Cration et attachement
   * du calendrier dans la fentre */
  Calendrier = gtk_calendar_new();
  gtk_container_add(GTK_CONTAINER(Fenetre), Calendrier);
  /* On fixe les options d'affichage du calendrier */
  gtk_calendar_display_options(GTK_CALENDAR(Calendrier),
                            GTK_CALENDAR_SHOW_HEADING |
                            GTK_CALENDAR_SHOW_DAY_NAMES |
                            GTK_CALENDAR_SHOW_WEEK_NUMBERS |
                            GTK_CALENDAR_WEEK_START_MONDAY);
  /* On marque le 15 du mois */
  gtk_calendar_mark_day(GTK_CALENDAR(Calendrier), 15);
  /* On connecte le signal "day_selected_double_click" */
  gtk_signal_connect(GTK_OBJECT(Calendrier),
                     "day_selected_double_click",
                     (GtkSignalFunc)AfficheDate, NULL);
  /* On affiche le dialogue */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
