/* FileSelect.c */
#include <stdio.h>
#include <gtk/gtk.h>

gboolean AfficheFichier(GtkFileSelection *Sel)
{
  gchar *NomFichier;

  NomFichier = gtk_file_selection_get_filename(Sel);
  printf("Fichier slectionn : %s\n", NomFichier);
  return TRUE;
}

int main(int argc, char *argv[])
{                                  
  GtkFileSelection *FichierDlg;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration du dialogue de slection de fichiers */
  FichierDlg = (GtkFileSelection *)
           gtk_file_selection_new("Test Slection fichier");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(FichierDlg), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(FichierDlg), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* On slectionne un fichier par dfaut */
  gtk_file_selection_set_filename(FichierDlg,
                    "/usr/src/linux/Documentation/Changes");
  /* Gestion des signaux du bouton 'OK' */
  gtk_signal_connect_object(
                          GTK_OBJECT(FichierDlg->ok_button),
                          "clicked",
                          (GtkSignalFunc)AfficheFichier,
                          GTK_OBJECT(FichierDlg));
  gtk_signal_connect_object(
                          GTK_OBJECT(FichierDlg->ok_button),
                          "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(FichierDlg));
  /* Gestion des signaux du bouton 'Cancel' */
  gtk_signal_connect_object(
                      GTK_OBJECT(FichierDlg->cancel_button),
                      "clicked",
                      (GtkSignalFunc)gtk_widget_destroy,
                      GTK_OBJECT(FichierDlg));

  /* On affiche le dialogue */
  gtk_widget_show(GTK_WIDGET(FichierDlg));

  /* La boucle principale */
  gtk_main();
  return 0;
}
