/* FontSelect.c */
#include <stdio.h>
#include <gtk/gtk.h>

gboolean AffichePolice(GtkFontSelectionDialog *FSD)
{
  gchar *NomPolice;
  
  NomPolice = gtk_font_selection_dialog_get_font_name(FSD);
  printf("Police slectionne : %s\n", NomPolice);
  return TRUE;
}

int main(int argc, char *argv[])
{                                  
  GtkFontSelectionDialog *FSD;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration du dialogue de slection de polices */
  FSD = (GtkFontSelectionDialog *)
        gtk_font_selection_dialog_new(
                                   "Test Slection police");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(FSD), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(FSD), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* Gestion des signaux du bouton 'OK' */
  gtk_signal_connect_object(GTK_OBJECT(FSD->ok_button),
                            "clicked",
                            (GtkSignalFunc)AffichePolice,
                            GTK_OBJECT(FSD));
  gtk_signal_connect_object(GTK_OBJECT(FSD->ok_button),
                          "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(FSD));
  /* Gestion des signaux du bouton 'Cancel' */
  gtk_signal_connect_object(GTK_OBJECT(FSD->cancel_button),
                          "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(FSD));

  /* On affiche le bouton Apply : */
  gtk_widget_show(FSD->apply_button);
  gtk_signal_connect_object(GTK_OBJECT(FSD->apply_button),
                            "clicked",
                            (GtkSignalFunc)AffichePolice,
                            GTK_OBJECT(FSD));
  
  /* On affiche le dialogue */
  gtk_widget_show(GTK_WIDGET(FSD));

  /* La boucle principale */
  gtk_main();
  return 0;
}
