/* SelectCol.c */
#include <stdio.h>
#include <gtk/gtk.h>

gboolean AfficheCouleur(GtkColorSelection *Sel)
{
  gdouble couleur[4];

  gtk_color_selection_get_color(Sel, couleur);
  printf("Rouge : %g, Vert : %g, Bleu : %g\n",
         couleur[0], couleur[1], couleur[2]);
  printf("Opacit : %g\n", couleur[3]);
  return TRUE;
}

int main(int argc, char *argv[])
{                                  
  GtkColorSelectionDialog *CouleurDlg;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration du dialogue de slection de couleur */
  CouleurDlg = (GtkColorSelectionDialog *)
                gtk_color_selection_dialog_new(
                             "Test Slection couleur");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(CouleurDlg), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(CouleurDlg), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* On veut utiliser l'opacit */
  gtk_color_selection_set_opacity(
               GTK_COLOR_SELECTION(CouleurDlg->colorsel),
               TRUE);

  /* On n'a pas besoin du bouton 'help',
   * alors on le cache... */
  gtk_widget_hide(CouleurDlg->help_button);

  /* Gestion des signaux du bouton 'OK' */
  gtk_signal_connect_object(
                 GTK_OBJECT(CouleurDlg->ok_button),
                 "clicked",
                 (GtkSignalFunc)AfficheCouleur,
                 GTK_OBJECT(CouleurDlg->colorsel));
  gtk_signal_connect_object(
                 GTK_OBJECT(CouleurDlg->ok_button),
                 "clicked",
                 (GtkSignalFunc)gtk_widget_destroy,
                 GTK_OBJECT(CouleurDlg));
  /* Gestion des signaux du bouton 'Cancel' */
  gtk_signal_connect_object(
                 GTK_OBJECT(CouleurDlg->cancel_button),
                 "clicked",
                 (GtkSignalFunc)gtk_widget_destroy,
                 GTK_OBJECT(CouleurDlg));
 
  /* On affiche le dialogue */
  gtk_widget_show(GTK_WIDGET(CouleurDlg));

  /* La boucle principale */
  gtk_main();
  return 0;
}
