/* BarreOutils.c */
#include <gtk/gtk.h>

static char *icone_xpm[] =
{
  "16 16 4 1",
  "       c None s None",
  ".      c black",
  "X      c white",
  "o      c #808080",
  "                ",
  "   .......      ",
  "   .XXXXX..     ",
  "   .XoooX.X.    ",
  "   .XXXXX....   ",
  "   .XooooXoo.o  ",
  "   .XXXXXXXX.o  ",
  "   .XooooooX.o  ",
  "   .XXXXXXXX.o  ",
  "   .XooooooX.o  ",
  "   .XXXXXXXX.o  ",
  "   .XooooooX.o  ",
  "   .XXXXXXXX.o  ",
  "   ..........o  ",
  "    oooooooooo  ",
  "                "
};

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *BarreOutils;
  GtkWidget *icone;
  GdkPixmap *pixmap;
  GdkBitmap *masque;
  GdkColor   transparent;
  GtkWidget *Entree;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(Fenetre),
                       "Test Barre d'outils");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* Cration et attachement de la barre d'outils */
  BarreOutils = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,
                                GTK_TOOLBAR_BOTH);
  gtk_container_add(GTK_CONTAINER(Fenetre), BarreOutils);
  /* On rgle quelques paramtres de la barre d'outils */
  gtk_toolbar_set_space_size(GTK_TOOLBAR(BarreOutils), 15);
  gtk_toolbar_set_space_style(GTK_TOOLBAR(BarreOutils),
                              GTK_TOOLBAR_SPACE_LINE);
  gtk_toolbar_set_button_relief(GTK_TOOLBAR(BarreOutils),
                                GTK_RELIEF_NONE);
  /* Cration du pixmap */
  gtk_widget_realize(Fenetre);
  pixmap = gdk_pixmap_create_from_xpm_d(Fenetre->window,
                                        &masque,
                                        &transparent,
                                        icone_xpm);
  icone = gtk_pixmap_new(pixmap, masque);
  gdk_pixmap_unref(pixmap);
  gdk_pixmap_unref(masque);
  /* On cre un bouton normal */
  gtk_toolbar_append_item(GTK_TOOLBAR(BarreOutils),
                          "Bouton 1",
                          "Aide du bouton 1",
                          NULL, icone,
                          NULL, NULL);
  /* Puis un espace */
  gtk_toolbar_append_space(GTK_TOOLBAR(BarreOutils));
  /* On rajoute un bouton commutateur */
  gtk_toolbar_append_element(GTK_TOOLBAR(BarreOutils),
                             GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                             NULL, "Bouton 2",
                             "Aide bouton 2",
                             NULL, icone, NULL, NULL);
  /* Et une entre de texte */
  Entree = gtk_entry_new();
  gtk_toolbar_append_widget(GTK_TOOLBAR(BarreOutils),
                            Entree, "Aide entre", NULL);

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
