/* BarresProgression.c */
#include <gtk/gtk.h>

GtkWidget *Barre1;
GtkWidget *Barre2;
GtkWidget *Barre3;

/* Cette fonction est appele 10 fois par seconde */
gint Timer(GtkAdjustment *adj)
{
  gfloat Valeur;

  Valeur = adj->value + 1;
  if (Valeur > adj->upper)
    Valeur = adj->lower;
  gtk_progress_set_value(GTK_PROGRESS(Barre1), Valeur);
  gtk_progress_set_value(GTK_PROGRESS(Barre2), Valeur);
  gtk_progress_set_value(GTK_PROGRESS(Barre3), Valeur);
  /* On ramorce le timer */
  return TRUE;
}

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Boite;
  GtkAdjustment *adj;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(Fenetre),
                       "Barres de progression");
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre),
                                 10);
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* La fentre contient une bote verticale
   * qui contiendra les barres */
  Boite = gtk_vbox_new(TRUE, 10);
  gtk_container_add(GTK_CONTAINER(Fenetre), Boite);

  /* Cration de l'ajustement pour les barres */
  adj = (GtkAdjustment *)gtk_adjustment_new(100, 100, 250,
                                            0, 0, 0);
  /* La valeur des barres de progression sera incrmente
   * par un timer */
  gtk_timeout_add(100, (GtkFunction)Timer, adj);
  /* La premire barre... */
  Barre1 = gtk_progress_bar_new_with_adjustment(adj);
  gtk_progress_set_show_text(GTK_PROGRESS(Barre1), TRUE);
  gtk_progress_set_format_string(GTK_PROGRESS(Barre1), 
                                 "%v de %l  %u (%p %%)");
  gtk_box_pack_start(GTK_BOX(Boite), Barre1, 
                     FALSE, FALSE, 5);
  
  /* La deuxime barre utilise le mode activit */
  Barre2 = gtk_progress_bar_new_with_adjustment(adj);
  gtk_progress_set_activity_mode(GTK_PROGRESS(Barre2),
                                 TRUE);
  gtk_progress_bar_set_activity_step(
                               GTK_PROGRESS_BAR(Barre2), 5);
  gtk_progress_bar_set_activity_blocks(
                               GTK_PROGRESS_BAR(Barre2), 3);
  gtk_box_pack_start(GTK_BOX(Boite), Barre2, 
                     FALSE, FALSE, 5);
  
  /* La troisime est en style discret 
   * et de la droite vers la gauche */
  Barre3 = gtk_progress_bar_new_with_adjustment(adj);
  gtk_progress_bar_set_bar_style(GTK_PROGRESS_BAR(Barre3),
                                 GTK_PROGRESS_DISCRETE);
  gtk_progress_bar_set_discrete_blocks(
                              GTK_PROGRESS_BAR(Barre3), 10);
  gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(Barre3),
                                GTK_PROGRESS_RIGHT_TO_LEFT);
  gtk_box_pack_start(GTK_BOX(Boite), Barre3, 
                     FALSE, FALSE, 5);
  
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
