/* ButtonBox.c */
#include <gtk/gtk.h>

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *BBox;
  GtkWidget *Bouton;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre),
                       "Test GtkButtonBox");
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* Cration de la barre de boutons */
  BBox = gtk_hbutton_box_new();
  gtk_container_add(GTK_CONTAINER(Fenetre), BBox);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(BBox),
                            GTK_BUTTONBOX_END);

  /* Cration des boutons */
  Bouton = gtk_button_new_with_label("Bouton 1");
  gtk_container_add(GTK_CONTAINER(BBox), Bouton);

  Bouton = gtk_button_new_with_label("Bouton 2");
  gtk_container_add(GTK_CONTAINER(BBox), Bouton);

  Bouton = gtk_button_new_with_label("Bouton 3");
  gtk_container_add(GTK_CONTAINER(BBox), Bouton);

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
