/* BullesAide.c */
#include <gtk/gtk.h>

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Boite;
  GtkWidget *Bouton;
  GtkTooltips *GroupeAide;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(Fenetre),
                       "Test Bulles d'aide");
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* Cration et attachement de la bote */
  Boite = gtk_hbox_new(TRUE, 5);
  gtk_container_add(GTK_CONTAINER(Fenetre), Boite);

  /* On cre un nouveau groupe de bulles d'aide */
  GroupeAide = gtk_tooltips_new();
  
  /* Un premier bouton */
  Bouton = gtk_button_new_with_label("Bouton 1");
  gtk_box_pack_start_defaults(GTK_BOX(Boite), Bouton);
  gtk_tooltips_set_tip(GroupeAide, Bouton,
                       "Bulle d'aide du premier bouton",
                       "");

  /* Le second bouton */
  Bouton = gtk_button_new_with_label("Bouton 2");
  gtk_box_pack_start_defaults(GTK_BOX(Boite), Bouton);
  gtk_tooltips_set_tip(GroupeAide, Bouton,
                       "Bulle d'aide du\nsecond bouton",
                       "");
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
