/* Style.c */
#include <gtk/gtk.h>

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *BoiteH;
  GtkWidget *Label;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Test Style");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /*  Cration de la bote horizontale */
  BoiteH = gtk_hbox_new(TRUE, 5);
  gtk_container_add(GTK_CONTAINER(Fenetre), BoiteH);      

  /* Le premier label, normal */
  Label = gtk_label_new("Label 1");
  gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Label);

  /* Le deuxime label avec une police "Agate" */
  Label = gtk_label_new("Label 2");
  gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Label);
  /* On change la police du style, notez que cela change
   * aussi la police du label 1 */
  Label->style->font =
        gdk_font_load("-*-agate-*-*-*-*-*-140-*-*-*-*-*-*");
  
  /* Le troisime label avec une police "dobkinscript" */
  Label = gtk_label_new("Label 3");
  gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Label);
  /* On cre une copie du style */
  Label->style = gtk_style_copy(Label->style);
  /* On change la police, seul ce bouton est concern */
  Label->style->font = gdk_font_load(
                "-*-dobkinscript-*-*-*--*-170-*-*-*-*-*-*");

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
