/* Agenda.c */
#include <gtk/gtk.h>
#include "menu.h"
#include "InterfaceRepertoire.h"
#include "InterfaceCalendrier.h"
#include "InterfaceIdees.h"

int main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *BoiteVerticale;
  GtkWidget *Menu;
  GtkWidget *NoteBook;

  /* Initialisation des bibliothques de gtk+ */
  gtk_init(&argc, &argv);

  /* Cration de la fentre principale */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  /* Connection des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                    (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);
 
  /* La boite verticale de la fentre principale */
  BoiteVerticale = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(Fenetre),
                    BoiteVerticale);
  
  /* Cration du menu */
  Menu = CreationMenu(Fenetre);
  gtk_box_pack_start(GTK_BOX(BoiteVerticale), Menu,
                     FALSE, FALSE, 0);
  /* Cration du notebook */
  NoteBook = gtk_notebook_new();
  gtk_box_pack_start_defaults(GTK_BOX(BoiteVerticale),
                              NoteBook);
  /* Cration de l'interface pour le rpertoire */
  AjoutePageRepertoire(NoteBook);
  /* Cration de l'interface pour le calendrier */
  AjoutePageCalendrier(NoteBook);
  /* Cration de l'interface pour le bloc-note */
  AjoutePageIdees(NoteBook);

  /* On affiche la fentre principale de l'application */
  gtk_widget_show_all(Fenetre);
  
  /* Boucle principale de GTK+ */
  gtk_main();
  return 0;
}
