/* InterfaceCalendrier.c */
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "InterfaceCalendrier.h"

typedef struct
{
  guint jour;
  guint mois;
  guint annee;
  gchar *message;
} DateStruct;

static GSList *Dates = NULL;

static GtkWidget *Calendrier;

static void MarqueMois(void)
{
  GSList *DateTmp;
  guint annee, mois, jour;

  gtk_calendar_get_date(GTK_CALENDAR(Calendrier),
                        &annee, &mois, &jour);

  gtk_calendar_clear_marks(GTK_CALENDAR(Calendrier));
  for (DateTmp = Dates ; DateTmp ; DateTmp = DateTmp->next)
  {
    DateStruct *Date;

    Date = (DateStruct *)(DateTmp->data);
    if ((Date->annee == annee) && (Date->mois == mois))
      gtk_calendar_mark_day(GTK_CALENDAR(Calendrier),
                            Date->jour);
  }
}

static void ChargeFichierCalendrier(GtkFileSelection *SelFic)
{
  char *NomFichier;
  FILE *Fichier;

  NomFichier = gtk_file_selection_get_filename(SelFic);

  if ((!NomFichier) || (strcmp(NomFichier,"") == 0))
    return ;
  /* Suppression des messages actuels */
  while (Dates)
  {
    DateStruct *Date;
    Date = (DateStruct *)(Dates->data);

    Dates = g_slist_remove_link(Dates, Dates);
    g_free(Date);
  }
  /* Ouverture du fichier */
  Fichier = fopen(NomFichier, "r");
  if (Fichier == NULL)
    return ;
  while (!feof(Fichier))
  {
    gchar Tampon[2048];
    DateStruct *Date;
    guint TailleMessage;

    /* Lecture du jour */
    fgets(Tampon, 2000, Fichier);
    if (feof(Fichier)) continue;
    Date = g_malloc(sizeof(DateStruct));
    Dates = g_slist_append(Dates, Date);
    Date->jour = atoi(Tampon);
    /* Lecture du mois */
    fgets(Tampon, 2000, Fichier);
    Date->mois = atoi(Tampon);
    /* Lecture de l'anne */
    fgets(Tampon, 2000, Fichier);
    Date->annee = atoi(Tampon);
    /* Lecture du message */
    TailleMessage = 2048;
    Date->message = g_malloc(TailleMessage);
    Date->message[0] = 0;
    Tampon[0] = 0;
    while (Tampon[0] != '%')
    {
      fgets(Tampon, 2000, Fichier);
      if (Tampon[0] != '%')
      {
        if (strlen(Date->message)+strlen(Tampon)+1 >
            TailleMessage)
        {
          TailleMessage *= 2;
          Date->message = g_realloc(Date->message,
                                    TailleMessage);
        }
        strcat(Date->message, Tampon);
      }
    }
  }
  /* Fermeture du fichier */
  fclose(Fichier);
  MarqueMois();
}            

void ChargementCalendrier(void)
{
  GtkWidget *SelecteurFichier;
  GtkWidget *Bouton;

  /* Cration du slecteur de fichier */
  SelecteurFichier = gtk_file_selection_new(
                           "Chargement fichier calendrier");

  /* Connexion du bouton ok_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->ok_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)ChargeFichierCalendrier,
                     GTK_OBJECT(SelecteurFichier));
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(SelecteurFichier));
  /* Connexion du bouton cancel_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->
                                              cancel_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(SelecteurFichier));
  gtk_widget_show(SelecteurFichier);
}

static void SauveFichierCalendrier(GtkFileSelection *SelFic)
{
  char *NomFichier;
  FILE *Fichier;
  GSList *DateTmp;

  NomFichier = gtk_file_selection_get_filename(SelFic);

  if ((!NomFichier) || (strcmp(NomFichier,"") == 0))
    return ;
  /* Ouverture du fichier */
  Fichier = fopen(NomFichier, "w");
  if (Fichier == NULL)
    return ;
  for (DateTmp = Dates ; DateTmp ; DateTmp = DateTmp->next)
  {
    DateStruct *Date;

    Date = (DateStruct *)(DateTmp->data);
    /* Ecriture dans le fichier */
    fprintf(Fichier, "%d\n%d\n%d\n%s\n%%\n", 
            Date->jour, Date->mois, Date->annee,
            Date->message);
  }
  /* Fermeture du fichier */
  fclose(Fichier);
}

void SauvegardeCalendrier(void)
{
  GtkWidget *SelecteurFichier;
  GtkWidget *Bouton;

  /* Cration du slecteur de fichier */
  SelecteurFichier = gtk_file_selection_new(
                           "Sauvegarde fichier calendrier");

  /* Connexion du bouton ok_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->ok_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                      (GtkSignalFunc)SauveFichierCalendrier,
                      GTK_OBJECT(SelecteurFichier));
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(SelecteurFichier));
  /* Connexion du bouton cancel_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->
                                              cancel_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(SelecteurFichier));
  gtk_widget_show(SelecteurFichier);
}

static DateStruct *RechercheDate(guint jour,
                                 guint mois,
                                 guint annee)
{
  GSList *DateTmp;

  for (DateTmp = Dates ; DateTmp ; DateTmp = DateTmp->next)
  {
    DateStruct *Date;

    Date = (DateStruct *)(DateTmp->data);
    if ((Date->annee == annee) &&
        (Date->mois == mois) &&
        (Date->jour == jour))
      return Date;
  }

  return NULL;
}

static void MiseAJourMessage(GtkObject *Texte)
{
  DateStruct *Date;

  Date = (DateStruct *)gtk_object_get_user_data(Texte);
  g_free(Date->message);
  Date->message = g_strdup(
                 gtk_editable_get_chars(GTK_EDITABLE(Texte),
                                        0, -1));
}

static void AfficheMessage(void)
{
  DateStruct *Date;
  guint annee, mois, jour;
  GtkWidget *Dialogue;
  GtkWidget *Scr;
  GtkWidget *Texte;
  GtkWidget *Bouton;

  gtk_calendar_get_date(GTK_CALENDAR(Calendrier),
                        &annee, &mois, &jour);
  Date = RechercheDate(jour, mois, annee);
  if (Date == NULL)
  { /* Il n'y a pas de messages, on en cre un */
    Date = g_malloc(sizeof(DateStruct));
    Date->annee = annee;
    Date->mois = mois;
    Date->jour = jour;
    Date->message = g_strdup("");
    Dates = g_slist_append(Dates, Date);
    MarqueMois();
  }
  Dialogue = gtk_dialog_new();
  /* Un GtkScrolledWindow pour contenir le texte */
  Scr = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start_defaults(
                        GTK_BOX(GTK_DIALOG(Dialogue)->vbox),
                        Scr);
  gtk_widget_set_usize(Scr, 150, 150);
  /* Le GtkText contenant le message */
  Texte = gtk_text_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(Scr), Texte);
  gtk_text_set_editable(GTK_TEXT(Texte), TRUE);
  gtk_text_insert(GTK_TEXT(Texte), NULL, NULL, NULL,
                  Date->message, -1);
  gtk_object_set_user_data(GTK_OBJECT(Texte), Date);

  /* Le bouton de validation/fermeture */
  Bouton = gtk_button_new_with_label("Fermer");
  gtk_box_pack_start_defaults(
                 GTK_BOX(GTK_DIALOG(Dialogue)->action_area),
                 Bouton);
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(Bouton);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                            (GtkSignalFunc)MiseAJourMessage,
                            GTK_OBJECT(Texte));
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(Dialogue));
  gtk_widget_show_all(Dialogue);
}

static void EffaceMessage(void)
{
  DateStruct *Date;
  guint annee, mois, jour;

  gtk_calendar_get_date(GTK_CALENDAR(Calendrier),
                        &annee, &mois, &jour);
  Date = RechercheDate(jour, mois, annee);
  Dates = g_slist_remove(Dates, Date);
  g_free(Date);
  MarqueMois();
}

void AjoutePageCalendrier(GtkWidget *NoteBook)
{
  GtkWidget *Frame;
  GtkWidget *LabelOnglet;
  GtkWidget *LabelMenu;
  GtkWidget *BoiteV;
  GtkWidget *Alignement;
  GtkWidget *Separateur;
  GtkWidget *Bouton;

  Frame = gtk_frame_new(NULL);
  gtk_container_set_border_width(GTK_CONTAINER(Frame), 10);

  LabelOnglet = gtk_label_new("Calendrier");
  LabelMenu = gtk_label_new("Calendrier");
  gtk_notebook_append_page_menu(GTK_NOTEBOOK(NoteBook),
                                Frame,
                                LabelOnglet, LabelMenu);
  /* Une boite verticale pour contenir le tout */
  BoiteV = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(Frame), BoiteV);
  /* Un alignement pour que le calendrier soit
   * toujours centr */ 
  Alignement = gtk_alignment_new(0.5, 0.5, 0.8, 0.8);
  gtk_box_pack_start_defaults(GTK_BOX(BoiteV), Alignement);

  /* Le calendrier */
  Calendrier = gtk_calendar_new();
  gtk_container_add(GTK_CONTAINER(Alignement), Calendrier);
  gtk_signal_connect(GTK_OBJECT(Calendrier),
                     "month_changed",
                     (GtkSignalFunc)MarqueMois, NULL);
  gtk_signal_connect(GTK_OBJECT(Calendrier),
                     "day_selected_double_click",
                     (GtkSignalFunc)AfficheMessage,
                     NULL);
  /* Un sparateur */
  Separateur = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(BoiteV), Separateur,
                     FALSE, FALSE, 0);
  /* Le bouton "Effacer" */
  Bouton = gtk_button_new_with_label("Effacer");
  gtk_box_pack_start(GTK_BOX(BoiteV), Bouton,
                     FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)EffaceMessage, NULL);
}

