/* InterfaceIdees.c */
#include <stdio.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "InterfaceIdees.h"

static guint LigneSelectionnee = -1;
static GtkWidget *CListe;
static GtkWidget *Texte;

static void ChargeFichierIdees(GtkFileSelection *SelFic)
{
  char *NomFichier;
  FILE *Fichier;
  int i;

  NomFichier = gtk_file_selection_get_filename(SelFic);

  if ((!NomFichier) || (strcmp(NomFichier,"") == 0))
    return ;

  /* On supprime les ides actuellement prsentes */
  for (i=0 ; i<GTK_CLIST(CListe)->rows ; i++)
  {
    gpointer Idee;
    Idee = gtk_clist_get_row_data(GTK_CLIST(CListe), i);
    g_free(Idee);
  }
  gtk_clist_clear(GTK_CLIST(CListe));
  
  /* Ouverture du fichier */
  Fichier = fopen(NomFichier, "r");
  if (Fichier == NULL)
    return ;

  while (!feof(Fichier))
  {
    guint Ligne;
    gchar *Textes[1];
    gchar Tampon[2048];
    gchar *Idee;
    guint TailleIdee;

    /* Lecture du nom de l'ide */
    fgets(Tampon, 2000, Fichier);
    if (feof(Fichier)) continue;
    Textes[0] = Tampon;
    Ligne = gtk_clist_append(GTK_CLIST(CListe), Textes);

    /* Lecture de l'ide */
    TailleIdee = 2048;
    Idee = g_malloc(TailleIdee);
    Idee[0] = 0;
    Tampon[0] = 0;
    while (Tampon[0] != '%')
    {
      fgets(Tampon, 2000, Fichier);
      if (Tampon[0] != '%')
      {
        if (strlen(Idee)+strlen(Tampon)+1 > TailleIdee)
        {
          TailleIdee *= 2;
          Idee = g_realloc(Idee, TailleIdee);
        }
        strcat(Idee, Tampon);
      }
    }
    gtk_clist_set_row_data(GTK_CLIST(CListe), Ligne,
                           (gpointer)Idee);
    /* On slectionne cette ide */
    gtk_clist_select_row(GTK_CLIST(CListe), Ligne, 0);
  }
  /* Fermeture du fichier */
  fclose(Fichier);
}

void ChargementIdees(void)
{
  GtkWidget *SelecteurFichier;
  GtkWidget *Bouton;

  /* Cration du slecteur de fichier */
  SelecteurFichier = gtk_file_selection_new(
                                "Chargement fichier ides");

  /* Connexion du bouton ok_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->ok_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                            (GtkSignalFunc)ChargeFichierIdees,
                            GTK_OBJECT(SelecteurFichier));
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(SelecteurFichier));
  /* Connexion du bouton cancel_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->
                                              cancel_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(SelecteurFichier));
  gtk_widget_show(SelecteurFichier);
}

static void SauveFichierIdees(GtkFileSelection *SelFic)
{
  char *NomFichier;
  FILE *Fichier;
  int i;

  NomFichier = gtk_file_selection_get_filename(SelFic);

  if ((!NomFichier) || (strcmp(NomFichier,"") == 0))
    return ;
  /* Si une ligne est slectionne, on la met  jour */
  if (LigneSelectionnee != -1)
  {
    gchar *TexteIdee;
    TexteIdee = (gchar *)
                gtk_clist_get_row_data(GTK_CLIST(CListe), 
                                       LigneSelectionnee);
    if (TexteIdee)
    {
      g_free(TexteIdee);
      TexteIdee = g_strdup(
        gtk_editable_get_chars(GTK_EDITABLE(Texte), 0, -1));
      gtk_clist_set_row_data(GTK_CLIST(CListe), 
                             LigneSelectionnee,
                             (gpointer)TexteIdee);
    }
  }
  /* Ouverture du fichier */
  Fichier = fopen(NomFichier, "w");
  if (Fichier == NULL)
    return ;
  for (i=0 ; i<GTK_CLIST(CListe)->rows ; i++)
  {
    gchar *NomIdee;
    gchar *Idee;

    /* Rcupration du nom de l'ide */
    gtk_clist_get_text(GTK_CLIST(CListe), i, 0, &NomIdee);
    Idee = gtk_clist_get_row_data(GTK_CLIST(CListe), i);
    /* Ecriture dans le fichier */
    fprintf(Fichier, "%s\n%s\n%%\n", NomIdee, Idee);
  } 
  /* Fermeture du fichier */
  fclose(Fichier);
}

void SauvegardeIdees(void)
{
  GtkWidget *SelecteurFichier;
  GtkWidget *Bouton;

  /* Cration du slecteur de fichier */
  SelecteurFichier = gtk_file_selection_new(
                                "Sauvegarde fichier ides");

  /* Connexion du bouton ok_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->ok_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                            (GtkSignalFunc)SauveFichierIdees,
                            GTK_OBJECT(SelecteurFichier));
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(SelecteurFichier));
  /* Connexion du bouton cancel_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->
                                              cancel_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(SelecteurFichier));
  gtk_widget_show(SelecteurFichier);
}

/* La fonction d'ajout d'une ide */
static void AjouteIdee(GtkWidget *Entree)
{
  gchar *Textes[1];
  gint Ligne;
  gchar *TexteIdee;

  Textes[0] = gtk_entry_get_text(GTK_ENTRY(Entree));
  if (Textes[0] && strcmp(Textes[0], ""))
  { /* On ne cre l'ide que si elle n'est pas vide */
    Ligne = gtk_clist_append(GTK_CLIST(CListe), Textes);

    /* Cration du texte de l'ide */
    TexteIdee = g_strdup("Nouvelle ide");
    gtk_clist_set_row_data(GTK_CLIST(CListe), Ligne,
                           (gpointer)TexteIdee);
    /* On slectionne cette ide */
    gtk_clist_select_row(GTK_CLIST(CListe), Ligne, 0);
  }
}

/* La boite de dialogue qui est affiche
 * pour ajouter une nouvelle ide */
static void DialogueAjouter(GtkWidget *w)
{
  GtkWidget *Dialogue;
  GtkWidget *BoiteH;
  GtkWidget *Label;
  GtkWidget *Entree;
  GtkWidget *Bouton;
  
  /* La boite de dialogue proprement dite */
  Dialogue = gtk_dialog_new();
  /* La boite horizontale principale */
  BoiteH = gtk_hbox_new(TRUE, 10);
  gtk_box_pack_start_defaults(
               GTK_BOX(GTK_DIALOG(Dialogue)->vbox), BoiteH);
    /* Le label "Nom de l'ide" */
    Label = gtk_label_new("Nom de l'ide : ");
    gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Label);
    /* L'entre de texte */
    Entree = gtk_entry_new();
    gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Entree);

  /* Le bouton "OK" */
  Bouton = gtk_button_new_with_label("OK");
  gtk_box_pack_start_defaults(
        GTK_BOX(GTK_DIALOG(Dialogue)->action_area), Bouton);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                            (GtkSignalFunc)AjouteIdee,
                            GTK_OBJECT(Entree));
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(Bouton);
    
  /* Le bouton "Annuler" */
  Bouton = gtk_button_new_with_label("Annuler");
  gtk_box_pack_start_defaults(
        GTK_BOX(GTK_DIALOG(Dialogue)->action_area), Bouton);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);

  /* Affichage de la boite de dialogue */
  gtk_widget_show_all(Dialogue);
}

/* La suppression d'une ide */
static void EffaceIdee(GtkWidget *w)
{
  gchar *TexteIdee;
  guint Ligne = LigneSelectionnee;

  /* On supprime d'abord le texte de l'ide */
  TexteIdee = (gchar *)
              gtk_clist_get_row_data(GTK_CLIST(CListe),
                                     LigneSelectionnee);
  g_free(TexteIdee);
  /* Puis la ligne de l'ide */
  LigneSelectionnee = -1;
  gtk_editable_delete_text(GTK_EDITABLE(Texte), 0, -1);
  gtk_clist_remove(GTK_CLIST(CListe), Ligne);
}

/* La boite de dialogue qui est affiche
 * pour effacer une ide existante */
static void DialogueEffacer(GtkWidget *w)
{
  GtkWidget *Dialogue;
  GtkWidget *Label;
  GtkWidget *Bouton;

  if (LigneSelectionnee == -1)
    return ;

  /* La boite de dialogue */
  Dialogue = gtk_dialog_new();
  /* Le label  */
  Label = gtk_label_new("Voulez-vous vraiment\n"
                        "supprimer cette ide ?");
  gtk_box_pack_start_defaults(
                GTK_BOX(GTK_DIALOG(Dialogue)->vbox), Label);
 
  /* Le bouton "Oui" */
  Bouton = gtk_button_new_with_label("Oui");
  gtk_box_pack_start_defaults(
        GTK_BOX(GTK_DIALOG(Dialogue)->action_area), Bouton);
  gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)EffaceIdee, NULL);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
    
  /* Le bouton "Non" */
  Bouton = gtk_button_new_with_label("Non");
  gtk_box_pack_start_defaults(
        GTK_BOX(GTK_DIALOG(Dialogue)->action_area), Bouton);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(Bouton);

  /* Affichage de la boite de dialogue */
  gtk_widget_show_all(Dialogue);
}

/* Gestion du signal "select_row" de la cliste */
static void SelectionIdee(GtkCList *CListe,
                          gint Ligne)
{
  gchar *TexteIdee;

  TexteIdee = (gchar *)
              gtk_clist_get_row_data(GTK_CLIST(CListe),
                                     Ligne);
  gtk_editable_delete_text(GTK_EDITABLE(Texte), 0, -1);
  gtk_text_insert(GTK_TEXT(Texte), NULL, NULL, NULL,
                  TexteIdee, -1);
  LigneSelectionnee = Ligne;
}

/* Gestion du signal "unselect_row" de la cliste */
static void DeselectionIdee(GtkCList *CListe,
                            gint Ligne)
{
  gchar *TexteIdee;

  if (LigneSelectionnee == -1)
    return ;
  /* Mise  jour de la donne attache */
  TexteIdee = (gchar *)
              gtk_clist_get_row_data(GTK_CLIST(CListe), 
                                     Ligne);
  if (TexteIdee)
  {
    g_free(TexteIdee);
    TexteIdee = g_strdup(
        gtk_editable_get_chars(GTK_EDITABLE(Texte), 0, -1));
    gtk_clist_set_row_data(GTK_CLIST(CListe), Ligne,
                           (gpointer)TexteIdee);
  }
  /* On efface le contenu du GtkText */
  gtk_editable_delete_text(GTK_EDITABLE(Texte), 0, -1);
  LigneSelectionnee = -1;
}

/* Cration de la page du notebook contenant
 * l'essentiel de l'interface des la boites  ides */
void AjoutePageIdees(GtkWidget *NoteBook)
{
  GtkWidget *Frame;
  GtkWidget *LabelOnglet;
  GtkWidget *LabelMenu;
  GtkWidget *BoiteV;
  GtkWidget *HPaned;
  GtkWidget *Scr;
  GtkWidget *Separateur;
  GtkWidget *BoiteH;
  GtkWidget *Bouton;
  gchar *Titre[] = {"Ides"};

  Frame = gtk_frame_new(NULL);
  gtk_container_set_border_width(GTK_CONTAINER(Frame), 10);

  LabelOnglet = gtk_label_new("Ides");
  LabelMenu = gtk_label_new("Ides");
  gtk_notebook_append_page_menu(GTK_NOTEBOOK(NoteBook),
                                Frame,
                                LabelOnglet, LabelMenu);

  /* Une boite verticale pour contenir les lments de 
   * l'interface de la page Ides */
  BoiteV = gtk_vbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(Frame), BoiteV);

  /* Cration et attachement du paned horizontal */
  HPaned = gtk_hpaned_new();
  gtk_box_pack_start_defaults(GTK_BOX(BoiteV), HPaned);

  /* Le texte des ides */          
    /*  Cration du GtkScrolledWindow */
    Scr = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Scr),
                                   GTK_POLICY_AUTOMATIC,
                                   GTK_POLICY_AUTOMATIC);

    gtk_paned_add2(GTK_PANED(HPaned), Scr);
    /* Cration du GtkText */
    Texte = gtk_text_new(NULL, NULL);
    gtk_container_add(GTK_CONTAINER(Scr), Texte);
    gtk_text_set_editable(GTK_TEXT(Texte), TRUE);

  /* La liste des ides */
    /*  Cration du GtkScrolledWindow */
    Scr = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Scr),
                                   GTK_POLICY_AUTOMATIC,
                                   GTK_POLICY_AUTOMATIC);

    gtk_paned_add1(GTK_PANED(HPaned), Scr);
    /* Cration du GtkList */
    CListe = gtk_clist_new_with_titles(1, Titre);
    gtk_widget_set_usize(CListe, 150, 150);
    gtk_container_add(GTK_CONTAINER(Scr), CListe);

    gtk_signal_connect(GTK_OBJECT(CListe), "select_row",
                       (GtkSignalFunc)SelectionIdee,
                       NULL);
    gtk_signal_connect(GTK_OBJECT(CListe), "unselect_row",
                       (GtkSignalFunc)DeselectionIdee,
                       NULL);

  /* Un sparateur horizontal */
  Separateur = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(BoiteV), Separateur,
                     FALSE, FALSE, 0);
  /* La boite horizontale des boutons */
  BoiteH = gtk_hbox_new(TRUE, 5);
  gtk_box_pack_start(GTK_BOX(BoiteV), BoiteH,
                     FALSE, FALSE, 0);
    /* Le bouton "Ajouter" */
    Bouton = gtk_button_new_with_label("Ajouter");
    gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Bouton);
    gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                       (GtkSignalFunc)DialogueAjouter,
                       NULL);

    /* Le bouton "Effacer" */
    Bouton = gtk_button_new_with_label("Effacer");
    gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Bouton);
    gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                       (GtkSignalFunc)DialogueEffacer,
                       NULL);

}

