/* menu.c */

#include <gtk/gtk.h>

#include "menu.h"
#include "InterfaceRepertoire.h"
#include "InterfaceCalendrier.h"
#include "InterfaceIdees.h"
#include "apropos.h"

#define CHARGER_REPERTOIRE 1
#define SAUVER_REPERTOIRE  2
#define CHARGER_CALENDRIER 3
#define SAUVER_CALENDRIER  4
#define CHARGER_IDEES      5
#define SAUVER_IDEES       6
#define A_PROPOS           7

/* Les Traitements des entres de menu */
void TraitementMenu(GtkWidget *w, guint Operation)
{
  switch(Operation)
  {
    case CHARGER_REPERTOIRE:  ChargementRepertoire(); break;
    case SAUVER_REPERTOIRE:   SauvegardeRepertoire(); break;
    case CHARGER_CALENDRIER:  ChargementCalendrier(); break;
    case SAUVER_CALENDRIER:   SauvegardeCalendrier(); break;
    case CHARGER_IDEES:       ChargementIdees(); break;
    case SAUVER_IDEES:        SauvegardeIdees(); break;
    case A_PROPOS:            AfficheAPropos(); break;
  }
}

/* Le tableau des entres de menu */
static GtkItemFactoryEntry EntreesMenu[] =
{
  {"/_Fichier", NULL, NULL, 0, "<Branch>"},
  {"/Fichier/Charger fichier _rpertoire", "<control>R",
   TraitementMenu, CHARGER_REPERTOIRE, "<Item>"},
  {"/Fichier/Charger fichier _calendrier", "<control>L",
   TraitementMenu, CHARGER_CALENDRIER, "<Item>"},
  {"/Fichier/Charger fichier _ides", "<control>I",
   TraitementMenu, CHARGER_IDEES, "<Item>"},
  {"/Fichier/rien", NULL, NULL, 0, "<Separator>"},
  {"/Fichier/Sauvegarder fichier r_pertoire", "<alt>R",
   TraitementMenu, SAUVER_REPERTOIRE, "<Item>"},
  {"/Fichier/Sauvegarder fichier c_alendrier", "<alt>L",
   TraitementMenu, SAUVER_CALENDRIER, "<Item>"},
  {"/Fichier/Sauvegarder fichier i_des", "<alt>I",
   TraitementMenu, SAUVER_IDEES, "<Item>"},
  {"/Fichier/rien", NULL, NULL, 0, "<Separator>"},
  {"/Fichier/Quitter", "<control>Q",
   gtk_main_quit, 0, NULL},
  {"/_Aide", NULL, NULL, 0, "<LastBranch>"},
  {"/Aide/_A propos...", "<control>A", TraitementMenu,
    A_PROPOS, "<Item>"}
};

static guint NbEntrees = sizeof(EntreesMenu) / 
                         sizeof(GtkItemFactoryEntry);

GtkWidget *CreationMenu(GtkWidget *Fenetre)
{
  GtkWidget *BarreDetachable;
  GtkWidget *BarreMenu;
  GtkItemFactory *Fabrique;
  GtkAccelGroup *Raccourcis;

  BarreDetachable = gtk_handle_box_new();
  
  /* Le groupe de raccourcis de clavier */
  Raccourcis = gtk_accel_group_new();

  /* Cration de la fabrique */
  Fabrique = gtk_item_factory_new(GTK_TYPE_MENU_BAR,
                                  "<Main>",
                                  Raccourcis);
  /* Cration des entres de menus */
  gtk_item_factory_create_items(Fabrique, NbEntrees,
                                EntreesMenu, NULL);
  gtk_accel_group_attach(Raccourcis, GTK_OBJECT(Fenetre));

  /* On rcupre la barre de menu depuis la fabrique */
  BarreMenu = gtk_item_factory_get_widget(Fabrique,
                                          "<Main>");

  gtk_container_add(GTK_CONTAINER(BarreDetachable),
                    BarreMenu);
  return BarreDetachable;
}

