/* gdk clavier */
#include <stdio.h>
#include <gdk/gdk.h>

/*
 * Procdure de traitement des vnements
 * de type Key Press
 */
void TraitementKeyPress(GdkEventKey *ev)
{
  if (ev->length > 0)
    printf("Touche normale presse : %s\n",
           ev->string);
  else
    printf("Touche symbolique presse : %s\n",
           gdk_keyval_name(ev->keyval));
}

int main(int argc, char *argv[])
{
  GdkWindow *Fenetre;
  GdkWindowAttr attr;
  GdkEvent *ev;
  gboolean fini = FALSE;
  
  attr.width = 150;
  attr.height = 150;
  attr.wclass = GDK_INPUT_OUTPUT;
  attr.window_type = GDK_WINDOW_TOPLEVEL;
  attr.event_mask = GDK_KEY_PRESS_MASK;
  gdk_init(&argc, &argv);
  /* Cration de la fentre */
  Fenetre = gdk_window_new(NULL, &attr, 0);
  /* Affichage */
  gdk_window_show(Fenetre);
  /* Boucle d'attente des vnements */
  while (!fini)
    if (gdk_events_pending())
    {
      ev = gdk_event_get();
      if (ev)
      {
        switch (ev->type)
        {
          case GDK_DELETE:
            /* Si on recoit l'vnement delete,
             * on met fin  l'application
             */
            fini = TRUE;
            break;
          case GDK_KEY_PRESS:
            TraitementKeyPress((GdkEventKey *)ev);
            break;
          default:
            ;
        }
        gdk_event_free(ev);
      }
    }
  return 0;
}
