/* gdk expose */ 
#include <stdio.h>
#include <gdk/gdk.h>

int largeur = 150;
int hauteur = 150;

/*
 * Procdure de traitement des vnements
 * de type configure
 */
void TraitementConfigure(GdkEventConfigure *ev)
{
  largeur = ev->width;
  hauteur = ev->height;
  printf("Nouvelle largeur : %d\n", largeur);
  printf("Nouvelle hauteur : %d\n", hauteur);
}

/*
 * Procdure de traitement des vnements
 * de type expose
 */
void TraitementExpose(GdkEventExpose *ev)
{
  GdkGC *gc;
  GdkColormap *colormap;
  GdkColor couleur;

  /* on ne redessine la fentre que si c'est le dernier
   * vnement de la srie. */
  if (ev->count > 0)
    return;
  gc = gdk_gc_new(ev->window);
  colormap = gdk_colormap_get_system();
  gdk_color_white(colormap, &couleur);
  gdk_gc_set_foreground(gc, &couleur);
  gdk_draw_arc(ev->window, gc, TRUE,
               0,0, largeur,hauteur,
               0,64*360);
  gdk_gc_destroy(gc);
}

int main(int argc, char *argv[])
{
  GdkWindow *Fenetre;
  GdkWindowAttr attr;
  GdkEvent *ev;
  
  attr.width = largeur;
  attr.height = hauteur;
  attr.wclass = GDK_INPUT_OUTPUT;
  attr.window_type = GDK_WINDOW_TOPLEVEL;
  attr.event_mask = GDK_EXPOSURE_MASK;
  gdk_init(&argc, &argv);
  /* Cration de la fentre */
  Fenetre = gdk_window_new(NULL, &attr, 0);
  /* Affichage */
  gdk_window_show(Fenetre);
  /* Boucle d'attente des vnements */
  for(;;)
    if (gdk_events_pending())
    {
      ev = gdk_event_get();
      if (ev)
      {
        if (ev->type == GDK_EXPOSE)
        {
          printf("Evnement expose reu\n"); 
          TraitementExpose((GdkEventExpose *)ev);
        }
        else if (ev->type == GDK_CONFIGURE)
        {
          printf("Evnement configure reu\n");
          TraitementConfigure((GdkEventConfigure *)ev);
        }
        gdk_event_free(ev);
      }
    }
}
