/* Fentres.c */
#include <gtk/gtk.h>

void main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *Dialogue;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* La fentre principale */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  /* Le titre de la fentre principale */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Principale");
  /* Connection des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);
  /* On affiche la fentre principale */
  gtk_widget_show(Fenetre);

  /* La fentre de dialogue */
  Dialogue = gtk_window_new(GTK_WINDOW_DIALOG);
  /* Le titre de la fentre de dialogue */
  gtk_window_set_title(GTK_WINDOW(Dialogue), "Dialogue");
  /* On interdit le redimensionnement de 
   * la fentre de dialogue */
  gtk_window_set_policy(GTK_WINDOW(Dialogue),
                        FALSE, FALSE, FALSE);
  /* Il faut donc lui donner une taille minimale */
  gtk_widget_set_usize(Dialogue, 150, 150);
  /* On place la fentre de dialogue au centre */
  gtk_window_set_position(GTK_WINDOW(Dialogue),
                          GTK_WIN_POS_CENTER);
  /* La fentre de dialogue est au-dessus de l'autre */
  gtk_window_set_transient_for(GTK_WINDOW(Dialogue),
                               GTK_WINDOW(Fenetre));
  /* Connection des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Dialogue), "delete_event",
                     (GtkSignalFunc)gtk_widget_destroy,
                     NULL);
  gtk_signal_connect(GTK_OBJECT(Dialogue), "destroy",
                     (GtkSignalFunc)gtk_widget_destroy,
                     NULL);
  /* On affiche la fentre de dialogue */
  gtk_widget_show(Dialogue);      

  /* La boucle principale */
  gtk_main();
}
