#include <gtk/gtk.h>

int main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *Bouton;
  GdkPixmap *Icone;
  GdkBitmap *Mask;
  GtkWidget *Pixmap;
  
  gtk_init(&argc, &argv);
  /* Cration de la fentre principale */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  /* On a besoin d'un widget ralis.
   * Ainsi, il possde une fentre X propre que
   * l'on peut utiliser pour crer le pixmap */
  gtk_widget_realize(Fenetre);
  /* On laisse un peu de place autour du bouton... */
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 10);
  
  /* Cration du bouton (vide) et
     placement dans la fentre */
  Bouton = gtk_button_new();
  gtk_container_add(GTK_CONTAINER(Fenetre), Bouton);
  
  /* Cration du pixmap */
  Icone = gdk_pixmap_create_from_xpm(Fenetre->window, 
                                     &Mask, NULL,
                                     "pixmap.xpm");
  Pixmap = gtk_pixmap_new(Icone, Mask);
  gdk_pixmap_unref(Icone); /* Comme on a plus besoin de */
  gdk_pixmap_unref(Mask);  /* ces deux-l, on libre la 
                               mmoire qu'ils utilisent */
  
  /* Installation du pixmap dans le bouton */
  gtk_container_add(GTK_CONTAINER(Bouton), Pixmap);
  
  /* Affichage des trois widgets */
  gtk_widget_show_all(Fenetre);
  
  gtk_main();
}
