/* MenuBarre.c */
#include <stdio.h>
#include <gtk/gtk.h>

gboolean CallBack(GtkWidget *menu_entry, gchar *texte)
{
  printf("%s\n", texte);
  return TRUE;
}

void main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *MenuBar;
  GtkWidget *MenuItem;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre de dialogue */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 5);
  /* Connection des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit,
                     NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit,
                     NULL);

  /* Cration et attachement de la barre de menus */
  MenuBar = gtk_menu_bar_new();
  gtk_container_add(GTK_CONTAINER(Fenetre), MenuBar);
  /* Cration et attachement de la premire entre */
  MenuItem = gtk_menu_item_new_with_label("Fichier");
  gtk_menu_bar_append(GTK_MENU_BAR(MenuBar), MenuItem);
  gtk_signal_connect(GTK_OBJECT(MenuItem), "activate",
                     (GtkSignalFunc)CallBack,
                     (gpointer)"Menu Fichier");
  /* Cration et attachement de la deuxime entre */
  MenuItem = gtk_menu_item_new_with_label("Edition");
  gtk_menu_bar_append(GTK_MENU_BAR(MenuBar), MenuItem);
  gtk_signal_connect(GTK_OBJECT(MenuItem), "activate",
                     (GtkSignalFunc)CallBack,
                     (gpointer)"Menu Edition");
  /* Cration et attachement de la dernire entre */
  MenuItem = gtk_menu_item_new_with_label("Aide");
  gtk_menu_bar_append(GTK_MENU_BAR(MenuBar), MenuItem);
  gtk_signal_connect(GTK_OBJECT(MenuItem), "activate",
                     (GtkSignalFunc)CallBack,
                     (gpointer)"Menu Aide");
  gtk_menu_item_right_justify(GTK_MENU_ITEM(MenuItem));
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);      

  /* La boucle principale */
  gtk_main();
}
