/* ScrolledWindow.c */
#include <stdio.h>
#include <gtk/gtk.h>

void main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *Src;
  GtkWidget *Table;
  int i,j;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre),
                       "Test GtkScrolledWindow");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /*  Cration du GtkScrolledWindow */
  Src = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(Fenetre), Src);

  /* Le GtkScrolledWindow contiendra une table de 10x10 */
  Table = gtk_table_new(10, 10, TRUE);
  gtk_scrolled_window_add_with_viewport(
                           GTK_SCROLLED_WINDOW(Src), Table);

  /* Remplissage de la table avec 50 labels et 50 boutons */
  for (i=0 ; i<10 ; i++)
    for (j=0 ; j<10 ; j++)
    {
      GtkWidget *widget;
      gchar *label;

      if ((i+j)%2)
      {
        label = g_strdup_printf("Bouton (%d, %d)", i,j);
        widget = gtk_button_new_with_label(label);
      } else
      {
        label = g_strdup_printf("Label (%d, %d)", i,j);
        widget = gtk_label_new(label);
      }
      g_free(label);
      gtk_table_attach_defaults(GTK_TABLE(Table), widget,
                                i,i+1, j,j+1);
    }
  
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
}
