/* Arbre.c */
#include <gtk/gtk.h>

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Scr;
  GtkWidget *arbre;
  int i;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Test GtkTree");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /*  Cration du GtkScrolledWindow */
  Scr = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(Fenetre), Scr);      
  gtk_widget_set_usize(Scr, 150, 100);

  /* Cration de l'arbre racine */
  arbre = gtk_tree_new();
  gtk_scrolled_window_add_with_viewport(
                         GTK_SCROLLED_WINDOW(Scr), arbre);

  /* Cration des lments de l'arbre racine */
  for (i=0 ; i<5 ; i++)
  {
    GtkWidget *Element;
    GtkWidget *SousArbre;
    gchar *label;
    int j;

    label = g_strdup_printf("lment %d", i+1);
    Element = gtk_tree_item_new_with_label(label);
    g_free(label);
    gtk_tree_append(GTK_TREE(arbre), Element);
    /* Cration des sous-arbres */
    SousArbre = gtk_tree_new();
    gtk_tree_item_set_subtree(GTK_TREE_ITEM(Element),
                              SousArbre);
    for (j=0 ; j<3 ; j++)
    {
      GtkWidget *SousElement;
      GtkWidget *SousSousArbre;
      gchar *souslabel;
      int k;

      souslabel = g_strdup_printf("sous-lment %d", j+1);
      SousElement = gtk_tree_item_new_with_label(souslabel);
      gtk_widget_show(SousElement);
      g_free(souslabel);
      gtk_tree_append(GTK_TREE(SousArbre), SousElement);

      /* Cration des sous-sous-arbres */
      SousSousArbre = gtk_tree_new();
      for (k=0 ; k<3 ; k++)
      {
        GtkWidget *SousSousElement;
        gchar *soussouslabel;

        soussouslabel = g_strdup_printf(
                               "sous-sous-lment %d", k+1);
        SousSousElement = gtk_tree_item_new_with_label(
                                             soussouslabel);
        gtk_widget_show(SousSousElement);
        g_free(soussouslabel);
        gtk_tree_append(GTK_TREE(SousSousArbre),
                        SousSousElement);
      }
      gtk_tree_item_set_subtree(GTK_TREE_ITEM(SousElement),
                                SousSousArbre);
    }
  }

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
