/* Preview.c */
#include <gtk/gtk.h>
#include <math.h>

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Preview;
  guchar points[100];
  gint i,j;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Test Preview");
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* Cration de la preview */
  Preview = gtk_preview_new(GTK_PREVIEW_GRAYSCALE);
  gtk_container_add(GTK_CONTAINER(Fenetre), Preview);
  /* La taille de la preview sera de 100x100 */
  gtk_preview_size(GTK_PREVIEW(Preview), 100, 100);

  /* On trace les 100 lignes */
  for (j=0 ; j<100 ; j++)
  { /* Pour chaque ligne, 
       on commence par remplir le tableau */
    for (i=0 ; i<100 ; i++)
      points[i] = 191+64*sin(i*M_PI/25)*cos(j*M_PI/25);
    /* et on envoie la ligne dans l'image de la preview */
    gtk_preview_draw_row(GTK_PREVIEW(Preview),
                         points,
                         0,j,
                         100);
  }

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
