/* BarreEtat.c */
#include <gtk/gtk.h>

guint id; /* L'identifiant de la srie de messages */

/* Cette fonction est attache au signal "clicked" 
 * du bouton "Ajoute"
 */
gboolean Ajoute(GtkStatusbar *Barre)
{
  static gint num = 0;
  gchar *message;

  num++;
  message = g_strdup_printf("Message %d", num);
  gtk_statusbar_push(Barre, id, message);
  g_free(message);
  return TRUE;
}

/* Cette fonction est attache au signal "clicked" 
 * du bouton "Retire"
 */
gboolean Retire(GtkStatusbar *Barre)
{
  gtk_statusbar_pop(Barre, id);
  return TRUE;
}

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Table;
  GtkWidget *Bouton;
  GtkWidget *BarreEtat;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(Fenetre),
                       "Test Barre d'tats");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);
  /* Cration et attachement de la table */
  Table = gtk_table_new(2, 2, FALSE);
  gtk_container_add(GTK_CONTAINER(Fenetre), Table);
  
  /* Cration et attachement de la barre d'tats */
  BarreEtat = gtk_statusbar_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), BarreEtat,
                            0,2, 1,2);
  /* Cration d'une srie */
  id = gtk_statusbar_get_context_id(GTK_STATUSBAR(BarreEtat),
                                    "Mes messages");
  /* Le bouton "Ajoute" */
  Bouton = gtk_button_new_with_label("Ajoute");
  gtk_table_attach_defaults(GTK_TABLE(Table), Bouton,
                            0,1, 0,1);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                            (GtkSignalFunc)Ajoute,
                            GTK_OBJECT(BarreEtat));
  /* Le bouton "Retire" */
  Bouton = gtk_button_new_with_label("Retire");
  gtk_table_attach_defaults(GTK_TABLE(Table), Bouton,
                            1,2, 0,1);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                            (GtkSignalFunc)Retire,
                            GTK_OBJECT(BarreEtat));
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
