/* visual gdk */
#include <stdio.h>
#include <gdk/gdk.h>

static const gchar* nom_des_visuals[] =
{
  "static gray",
  "grayscale",
  "static color",
  "pseudo color",
  "true color",
  "direct color"
};

void AfficheVisual(GdkVisual *visual)
{
  printf("  Type : %s, profondeur : %d\n",
         nom_des_visuals[visual->type],
         visual->depth);
}

int main(int argc, char *argv[])
{
  int *profondeurs;
  GdkVisualType *types;
  int n, i;
  GList *visuals;

  gdk_init(&argc, &argv);
  /* Les profondeurs */
  gdk_query_depths(&profondeurs, &n);
  printf("Profondeurs disponibles :");
  for (i=0 ; i<n-1 ; i++)
    printf(" %d,", profondeurs[i]);
  printf(" %d\n", profondeurs[i]);
  /* Les types de visuals */
  gdk_query_visual_types(&types, &n);
  printf("Types de visuals disponibles :");
  for (i=0 ; i<n-1 ; i++)
    printf(" %s,", nom_des_visuals[types[i]]);
  printf(" %s\n", nom_des_visuals[types[i]]);
  /* Les visuals */
  printf("Visuals disponibles :\n");
  visuals = gdk_list_visuals();
  g_list_foreach(visuals, (GFunc)AfficheVisual, NULL);
  return 0;
}
