/* Fabrique.c */
#include <stdio.h>
#include <gtk/gtk.h>

#define DOCUMENT    1
#define CHARGEMENT  2
#define SAUVEGARDE  3
#define COUPER      4
#define COPIER      5
#define COLLER      6
#define INSERT      7
#define BLEU        8
#define VERT        9
#define ROUGE      10
#define A_PROPOS   11

/* Les traitements des entres de menu */
void Traitement(GtkWidget *w, guint Operation)
{
  switch(Operation)
  {
    case DOCUMENT:    printf("Nouveau document\n"); break;
    case CHARGEMENT:  printf("Chargement\n"); break;
    case SAUVEGARDE:  printf("Sauvegarde\n"); break;
    case COUPER:      printf("Couper\n"); break;
    case COPIER:      printf("Copier\n"); break;
    case COLLER:      printf("Coller\n"); break;
    case INSERT:      printf("Insert\n"); break;
    case BLEU:        printf("Bleu\n"); break;
    case VERT:        printf("Vert\n"); break;
    case ROUGE:       printf("Rouge\n"); break;
    case A_PROPOS:    printf("A Propos\n"); break;
  }
}

/* Le tableau des entres de menu */
static GtkItemFactoryEntry tableau[] = {
 {"/_Fichier",                  NULL,         NULL,
  0,          "<Branch>"},
 {"/Fichier/_Nouveau",          NULL,         NULL,
  0,          "<Branch>"},
 {"/Fichier/Nouveau/_Document", "<control>O", Traitement,
  DOCUMENT,   "<Item>"},
 {"/Fichier/_Charger",          "<control>L", Traitement,
  CHARGEMENT, "<Item>"},
 {"/Fichier/_Sauvegarder",      "<control>S", Traitement,
  SAUVEGARDE, "<Item>"},
 {"/Fichier/rien",              NULL,         NULL,
  0,          "<Separator>"},
 {"/Fichier/Quitter",           "<control>Q", gtk_main_quit,
  0,          NULL},
 {"/_Edition",                  NULL,         NULL,
  0,          "<Branch>"},
 {"/Edition/_Couper",           "<control>X", Traitement,
  COUPER,     "<Item>"},
 {"/Edition/Co_pier",           "<control>C", Traitement,
  COPIER,     "<Item>"},
 {"/Edition/Col_ler",           "<control>V", Traitement,
  COLLER,     "<Item>"},
 {"/Edition/rien",              NULL,         NULL,
  0,          "<Separator>"},
 {"/Edition/Mode _Insertion",   NULL,         Traitement,
  INSERT,     "<CheckItem>"},
 {"/_Couleur",                  NULL,         NULL,
  0,          "<Branch>"},
 {"/Couleur/_Bleu",             "<alt>B",     Traitement,
  BLEU,       "<RadioItem>"},
 {"/Couleur/_Vert",             "<alt>V",     Traitement,
  VERT,       "/Couleur/Bleu"},
 {"/Couleur/_Rouge",            "<alt>R",     Traitement,
  ROUGE,      "/Couleur/Bleu"},
 {"/_Aide",                     NULL,         NULL,
  0,          "<LastBranch>"},
 {"/Aide/_A propos...",         "<control>A", Traitement,
  A_PROPOS,   "<Item>"}
};

int main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *BarreMenu;
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);
  
  /* Cration de la fentre principale */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(Fenetre),
                       "Test Fabrique");
  
  /* Le groupe de raccourcis clavier */
  accel_group = gtk_accel_group_new();

  /* Cration de la fabrique */
  item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR,
                                      "<Main>",
                                      accel_group);
  /* Cration des entres de menu */
  gtk_item_factory_create_items(item_factory, 19,
                                tableau, NULL);
  gtk_accel_group_attach(accel_group, GTK_OBJECT(Fenetre));
  /* On rcupre la barre de menus depuis la fabrique */
  BarreMenu = gtk_item_factory_get_widget(item_factory,
                                          "<Main>");
  /* On la place dans la fentre principale */
  gtk_container_add(GTK_CONTAINER(Fenetre), BarreMenu);
 
  /* On met  jour les raccourcis clavier
   * en fonction du fichier des raccourcis */
  gtk_item_factory_parse_rc("Raccourcis");
  
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);
  
  /* La boucle principale de GTK+ */
  gtk_main();

  /* On sauvegarde le fichier des raccourcis */
  gtk_item_factory_dump_rc("Raccourcis", NULL, FALSE);
  
  return 0;
}
