/* ZoneAide.c */
#include <gtk/gtk.h>

GtkTooltips *GroupeAide;
GtkWidget *ZoneAide;

gboolean AideEnZone(GtkWidget *Bouton)
{
  gtk_tooltips_disable(GroupeAide);
  gtk_tips_query_start_query(GTK_TIPS_QUERY(ZoneAide));
  return TRUE;
}

gboolean AideEnBulle(GtkWidget *Bouton)
{
  gtk_tooltips_enable(GroupeAide);
  gtk_tips_query_stop_query(GTK_TIPS_QUERY(ZoneAide));
  return TRUE;
}

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *Table;
  GtkWidget *Bouton;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(Fenetre),
                       "Test Bulles d'aide");
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /* Cration et attachement de la table */
  Table = gtk_table_new(2, 2, TRUE);
  gtk_container_add(GTK_CONTAINER(Fenetre), Table);

  /* On cre un nouveau groupe de bulles d'aide */
  GroupeAide = gtk_tooltips_new();
  
  /* Le bouton zone */
  Bouton = gtk_button_new_with_label("Zone");
  gtk_table_attach_defaults(GTK_TABLE(Table), Bouton, 
                            0,1, 0,1);
  gtk_tooltips_set_tip(GroupeAide, Bouton,
                       "Bulle d'aide du premier bouton",
                       "");
  gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)AideEnZone, NULL);

  /* Le bouton bulle */
  Bouton = gtk_button_new_with_label("Bulle");
  gtk_table_attach_defaults(GTK_TABLE(Table), Bouton,
                            1,2, 0,1);
  gtk_tooltips_set_tip(GroupeAide, Bouton,
                       "Bulle d'aide du\nsecond bouton",
                       "");
  gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)AideEnBulle, NULL);
  
  /* La zone d'aide */
  ZoneAide = gtk_tips_query_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), ZoneAide,
                            0,2, 1,2);
  
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
