/* RC.c */
#include <gtk/gtk.h>

int main(int argc, char *argv[])
{                                  
  GtkWidget *Fenetre;
  GtkWidget *BoiteH;
  GtkWidget *Label;
  GtkWidget *Bouton;
  
  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Lecture du fichier de style */
  gtk_rc_parse("TestRC");

  /* Cration de la fentre */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 8);
  /* Le titre de la fentre */
  gtk_window_set_title(GTK_WINDOW(Fenetre), "Test RC");
  /* Connexion des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit, NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit, NULL);

  /*  Cration de la bote horizontale */
  BoiteH = gtk_hbox_new(TRUE, 5);
  gtk_container_add(GTK_CONTAINER(Fenetre), BoiteH);      

  /* Le premier label, normal, avec le style
   * par dfaut des GtkLabels */
  Label = gtk_label_new(" Label 1 ");
  gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Label);

  /* Le second label avec le style "LabelRouge" */
  Label = gtk_label_new(" Label 2 ");
  gtk_widget_set_name(Label, "LabelRouge");
  gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Label);
  
  /* Un bouton avec le style "Bouton", son label garde le
   * style "Label"... */
  Bouton = gtk_button_new_with_label(" Bouton ");
  gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Bouton);

  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);

  /* La boucle principale */
  gtk_main();
  return 0;
}
