/* InterfaceRepertoire.c */
#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "InterfaceRepertoire.h"

static GtkCTreeNode *NoeudSelectionne = NULL;
static GtkWidget *CArbre;
static GtkCTreeNode *NoeudsLettre[26];
static GtkWidget *EntreePrenom;
static GtkWidget *EntreeTel;
static GtkWidget *TexteAdresse;

static void
ChargeFichierRepertoire(GtkFileSelection *SelFic)
{
  char *NomFichier;
  FILE *Fichier;
  int i;

  NomFichier = gtk_file_selection_get_filename(SelFic);

  if ((!NomFichier) || (strcmp(NomFichier,"") == 0))
    return ;

  /* On supprime toutes les entres du rpertoire */
  for (i=0 ; i<GTK_CLIST(CArbre)->rows ; i++)
  {
    GtkCTreeNode *Noeud;
    gchar **Donnees;

    Noeud = gtk_ctree_node_nth(GTK_CTREE(CArbre), i);
    if (gtk_ctree_node_get_selectable(GTK_CTREE(CArbre),
                                      Noeud))
    {
      Donnees = (gchar **) 
              gtk_ctree_node_get_row_data(GTK_CTREE(CArbre),
                                          Noeud);
      g_free(Donnees[0]);
      g_free(Donnees[1]);
      g_free(Donnees[2]);
      g_free(Donnees);
      gtk_ctree_remove_node(GTK_CTREE(CArbre), Noeud);
    }
  } 
  /* Ouverture du fichier */
  Fichier = fopen(NomFichier, "r");
  if (Fichier == NULL)
    return ;

  while (!feof(Fichier))
  {
    GtkCTreeNode *Noeud;
    gchar *Textes[1];
    gchar Tampon[2048];
    guint TailleAdresse;
    gint Index;
    gchar **Donnees;

    /* Lecture du nom */
    fgets(Tampon, 2000, Fichier);
    if (feof(Fichier)) continue;
    Textes[0] = Tampon;
    Index = toupper(Textes[0][0]) - 'A';

    Noeud = gtk_ctree_insert_node(GTK_CTREE(CArbre),
                                  NoeudsLettre[Index],
                                  NULL, Textes, 0,
                                  NULL, NULL, NULL, NULL,
                                  TRUE, FALSE);
    
    /* Cration des coordonnes */
    Donnees = g_malloc(3*sizeof(gchar*));
    Donnees[0] = g_malloc(2048);
    Donnees[1] = g_malloc(2048);
    gtk_ctree_node_set_row_data(GTK_CTREE(CArbre),
                                Noeud,
                                (gpointer)Donnees);
    /* Lecture du Prnom */
    fgets(Donnees[0], 2000, Fichier);
    /* Lecture du tlphone */
    fgets(Donnees[1], 2000, Fichier);
    
    /* Lecture de l'adresse */
    TailleAdresse = 2048;
    Donnees[2] = g_malloc(TailleAdresse);
    Donnees[2][0] = 0;
    Tampon[0] = 0;
    while (Tampon[0] != '%')
    {
      fgets(Tampon, 2000, Fichier);
      if (Tampon[0] != '%')
      {
        if (strlen(Donnees[2])+strlen(Tampon)+1 > 
            TailleAdresse)
        {
          TailleAdresse *= 2;
          Donnees[2] = g_realloc(Donnees[2], TailleAdresse);
        }
        strcat(Donnees[2], Tampon);
      }
    }
    /* On slectionne le nouveau nom */
    gtk_ctree_select(GTK_CTREE(CArbre), Noeud);
  }
  /* Fermeture du fichier */
  fclose(Fichier);
}

void ChargementRepertoire(void)
{
  GtkWidget *SelecteurFichier;
  GtkWidget *Bouton;

  /* Cration du slecteur de fichier */
  SelecteurFichier = gtk_file_selection_new(
                              "Chargement fichier rpertoire");

  /* Connexion du bouton ok_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->ok_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)ChargeFichierRepertoire,
                     GTK_OBJECT(SelecteurFichier));
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(SelecteurFichier));
  /* Connexion du bouton cancel_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->
                                              cancel_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(SelecteurFichier));
  gtk_widget_show(SelecteurFichier);
}

static void SauveFichierRepertoire(GtkFileSelection *SelFic)
{
  char *NomFichier;
  FILE *Fichier;
  int i;

  NomFichier = gtk_file_selection_get_filename(SelFic);

  if ((!NomFichier) || (strcmp(NomFichier,"") == 0))
    return ;
  /* Si un noeud est slectionn, on le met  jour */
  if (NoeudSelectionne)
  {
    gchar **Donnees;

    Donnees = (gchar **)
              gtk_ctree_node_get_row_data(GTK_CTREE(CArbre),
                                          NoeudSelectionne);
    if (Donnees)
    {
      /* Le prnom */
      g_free(Donnees[0]);
      Donnees[0] = g_strdup(
               gtk_entry_get_text(GTK_ENTRY(EntreePrenom)));
      /* Le tlphone */
      g_free(Donnees[1]);
      Donnees[1] = g_strdup(
                 gtk_entry_get_text(GTK_ENTRY(EntreeTel)));
      /* L'adresse */
      g_free(Donnees[2]);
      Donnees[2] = g_strdup(
          gtk_editable_get_chars(GTK_EDITABLE(TexteAdresse),
                               0, -1));
    }
  }
  /* Ouverture du fichier */
  Fichier = fopen(NomFichier, "w");
  if (Fichier == NULL)
    return ;
  for (i=0 ; i<GTK_CLIST(CArbre)->rows ; i++)
  {
    GtkCTreeNode *Noeud;
    gchar *Nom;
    gchar **Donnees;

    Noeud = gtk_ctree_node_nth(GTK_CTREE(CArbre), i);
    if (gtk_ctree_node_get_selectable(GTK_CTREE(CArbre),
                                      Noeud))
    {
      /* Rcupration du nom */
      gtk_ctree_node_get_pixtext(GTK_CTREE(CArbre), Noeud,
                                 0, &Nom, NULL, NULL, NULL);
      
      Donnees = (gchar **) 
              gtk_ctree_node_get_row_data(GTK_CTREE(CArbre),
                                          Noeud);
      /* Ecriture dans le fichier */
      fprintf(Fichier, "%s\n%s\n%s\n%s\n%%\n", Nom,
              Donnees[0], Donnees[1], Donnees[2]);
    }
  } 
  /* Fermeture du fichier */
  fclose(Fichier);
}

void SauvegardeRepertoire(void)
{
  GtkWidget *SelecteurFichier;
  GtkWidget *Bouton;

  /* Cration du slecteur de fichier */
  SelecteurFichier = gtk_file_selection_new(
                           "Sauvegarde fichier rpertoire");

  /* Connexion du bouton ok_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->ok_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                      (GtkSignalFunc)SauveFichierRepertoire,
                      GTK_OBJECT(SelecteurFichier));
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(SelecteurFichier));
  /* Connexion du bouton cancel_button */
  Bouton = GTK_FILE_SELECTION(SelecteurFichier)->
                                              cancel_button;
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(SelecteurFichier));
  gtk_widget_show(SelecteurFichier);
}

/* La fonction d'ajout d'une entre */
static void AjouteNom(GtkWidget *Entree)
{
  gchar *Textes[1];
  GtkCTreeNode *Noeud;
  gchar **Donnees;

  Textes[0] = gtk_entry_get_text(GTK_ENTRY(Entree));
  if (Textes[0] && strcmp(Textes[0], "") && 
      isalpha(Textes[0][0]))
  { /* On ne cre le nom que s'il n'est pas vide */
    gint Index;
    
    Index = toupper(Textes[0][0]) - 'A';
    
    Noeud = gtk_ctree_insert_node(GTK_CTREE(CArbre),
                                  NoeudsLettre[Index],
                                  NULL, Textes, 0,
                                  NULL, NULL, NULL, NULL,
                                  TRUE, FALSE);
    
    /* Cration des coordonnes */
    Donnees = g_malloc(3*sizeof(gchar*));
    Donnees[0] = g_strdup("");
    Donnees[1] = g_strdup("");
    Donnees[2] = g_strdup("");
    gtk_ctree_node_set_row_data(GTK_CTREE(CArbre),
                                Noeud,
                                (gpointer)Donnees);

    /* On slectionne ce nom */
    gtk_ctree_select(GTK_CTREE(CArbre), Noeud);
  }
}

/* La boite de dialogue qui est affiche
 * pour ajouter une nouvelle ide */
static void DialogueAjouter(GtkWidget *w)
{
  GtkWidget *Dialogue;
  GtkWidget *BoiteH;
  GtkWidget *Label;
  GtkWidget *Entree;
  GtkWidget *Bouton;
  
  /* La boite de dialogue proprement dite */
  Dialogue = gtk_dialog_new();
  /* La boite horizontale principale */
  BoiteH = gtk_hbox_new(TRUE, 10);
  gtk_box_pack_start_defaults(
               GTK_BOX(GTK_DIALOG(Dialogue)->vbox), BoiteH);
    /* Le label "Nom de l'ide" */
    Label = gtk_label_new("Nom : ");
    gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Label);
    /* L'entre de texte */
    Entree = gtk_entry_new();
    gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Entree);

  /* Le bouton "OK" */
  Bouton = gtk_button_new_with_label("OK");
  gtk_box_pack_start_defaults(
        GTK_BOX(GTK_DIALOG(Dialogue)->action_area), Bouton);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                            (GtkSignalFunc)AjouteNom,
                            GTK_OBJECT(Entree));
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(Bouton);
    
  /* Le bouton "Annuler" */
  Bouton = gtk_button_new_with_label("Annuler");
  gtk_box_pack_start_defaults(
        GTK_BOX(GTK_DIALOG(Dialogue)->action_area), Bouton);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);

  /* Affichage de la boite de dialogue */
  gtk_widget_show_all(Dialogue);
}

/* La suppression d'une entree */
static void EffaceNom(GtkWidget *w)
{
  gchar **Donnees;
  GtkCTreeNode *Noeud = NoeudSelectionne;

  if (NoeudSelectionne == NULL)
    return ;
  /* On supprime d'abord les donnes attaches */
  Donnees = (gchar **)
              gtk_ctree_node_get_row_data(GTK_CTREE(CArbre),
                                          NoeudSelectionne);
  g_free(Donnees[0]);
  g_free(Donnees[1]);
  g_free(Donnees[2]);
  g_free(Donnees);
  /* Puis le noeud lui-mme */
  gtk_entry_set_text(GTK_ENTRY(EntreePrenom), "");
  gtk_entry_set_text(GTK_ENTRY(EntreeTel), "");
  gtk_editable_delete_text(GTK_EDITABLE(TexteAdresse),
                           0, -1);
  NoeudSelectionne = NULL;
  gtk_ctree_remove_node(GTK_CTREE(CArbre), Noeud);
}

/* La boite de dialogue qui est affiche
 * pour effacer un nom dans le rpertoire */
static void DialogueEffacer(GtkWidget *w)
{
  GtkWidget *Dialogue;
  GtkWidget *Label;
  GtkWidget *Bouton;

  if (NoeudSelectionne == NULL)
    return ;

  /* La boite de dialogue */
  Dialogue = gtk_dialog_new();
  /* Le label  */
  Label = gtk_label_new("Voulez-vous vraiment\n"
                        "supprimer ce nom ?");
  gtk_box_pack_start_defaults(
                GTK_BOX(GTK_DIALOG(Dialogue)->vbox), Label);
 
  /* Le bouton "Oui" */
  Bouton = gtk_button_new_with_label("Oui");
  gtk_box_pack_start_defaults(
        GTK_BOX(GTK_DIALOG(Dialogue)->action_area), Bouton);
  gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)EffaceNom, NULL);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
    
  /* Le bouton "Non" */
  Bouton = gtk_button_new_with_label("Non");
  gtk_box_pack_start_defaults(
        GTK_BOX(GTK_DIALOG(Dialogue)->action_area), Bouton);
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(Bouton);

  /* Affichage de la boite de dialogue */
  gtk_widget_show_all(Dialogue);
}

/* Gestion du signal "tree_select_row" du carbre */
static void SelectionNom(GtkCTree *CArbre,
                         GtkCTreeNode *Noeud)
{
  gchar **Donnees;

  Donnees = (gchar **)
              gtk_ctree_node_get_row_data(GTK_CTREE(CArbre),
                                          Noeud);
  /* Le prnom */
  gtk_entry_set_text(GTK_ENTRY(EntreePrenom), Donnees[0]);
  /* Le tlphone */
  gtk_entry_set_text(GTK_ENTRY(EntreeTel), Donnees[1]);
  /* L'adresse */
  gtk_editable_delete_text(GTK_EDITABLE(TexteAdresse),
                           0, -1);
  gtk_text_insert(GTK_TEXT(TexteAdresse), NULL, NULL, NULL,
                  Donnees[2], -1);
  NoeudSelectionne = Noeud;
}

/* Gestion du signal "tree_unselect_row" du carbre */
static void DeselectionNom(GtkCTree *CArbre,
                           GtkCTreeNode *Noeud)
{
  gchar **Donnees;

  if (NoeudSelectionne == NULL)
    return ;
  /* Mise  jour des coordonnes */
  Donnees = (gchar **)
              gtk_ctree_node_get_row_data(GTK_CTREE(CArbre),
                                          Noeud);
  if (Donnees)
  {
    /* Le prnom */
    g_free(Donnees[0]);
    Donnees[0] = g_strdup(
               gtk_entry_get_text(GTK_ENTRY(EntreePrenom)));
    /* Le tlphone */
    g_free(Donnees[1]);
    Donnees[1] = g_strdup(
               gtk_entry_get_text(GTK_ENTRY(EntreeTel)));
    /* L'adresse */
    g_free(Donnees[2]);
    Donnees[2] = g_strdup(
        gtk_editable_get_chars(GTK_EDITABLE(TexteAdresse),
                               0, -1));
  }
  /* On efface les contenus des entres */
  gtk_entry_set_text(GTK_ENTRY(EntreePrenom), "");
  gtk_entry_set_text(GTK_ENTRY(EntreeTel), "");
  gtk_editable_delete_text(GTK_EDITABLE(TexteAdresse),
                           0, -1);
  NoeudSelectionne = NULL;
}

/* Cration de la page du notebook contenant
 * l'essentiel de l'interface du rpertoire */
void AjoutePageRepertoire(GtkWidget *NoteBook)
{
  GtkWidget *Frame;
  GtkWidget *LabelOnglet;
  GtkWidget *LabelMenu;
  GtkWidget *BoiteV;
  GtkWidget *HPaned;
  GtkWidget *Scr;
  GtkWidget *Table;
  GtkWidget *Label;
  GtkWidget *Separateur;
  GtkWidget *BoiteH;
  GtkWidget *Bouton;
  gchar *Titre[] = {"Rpertoire"};
  guint i;

  Frame = gtk_frame_new(NULL);
  gtk_container_set_border_width(GTK_CONTAINER(Frame), 10);

  LabelOnglet = gtk_label_new("Rpertoire");
  LabelMenu = gtk_label_new("Rpertoire");
  gtk_notebook_append_page_menu(GTK_NOTEBOOK(NoteBook),
                                Frame,
                                LabelOnglet, LabelMenu);

  /* Une boite verticale pour contenir les lments de 
   * l'interface de la page Ides */
  BoiteV = gtk_vbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(Frame), BoiteV);

  /* Cration et attachement du paned horizontal */
  HPaned = gtk_hpaned_new();
  gtk_box_pack_start_defaults(GTK_BOX(BoiteV), HPaned);

    /* La table pour les informations */
    Table = gtk_table_new(4, 2, FALSE);
    gtk_paned_add2(GTK_PANED(HPaned), Table);
    /* Le label Prnom */
    Label = gtk_label_new("Prnom : ");
    gtk_table_attach(GTK_TABLE(Table), Label,
                     0,1, 0,1, GTK_EXPAND | GTK_FILL,
                     GTK_FILL, 2, 5);
    /* L'entre prnom */
    EntreePrenom = gtk_entry_new();
    gtk_table_attach(GTK_TABLE(Table), EntreePrenom,
                     1,2, 0,1, GTK_EXPAND | GTK_FILL,
                     GTK_FILL, 2, 5);
    /* Le label Tlphone */
    Label = gtk_label_new("Tlphone : ");
    gtk_table_attach(GTK_TABLE(Table), Label,
                     0,1, 1,2, GTK_EXPAND | GTK_FILL,
                     GTK_FILL, 2, 5);
    /* L'entre tlphone */
    EntreeTel = gtk_entry_new();
    gtk_table_attach(GTK_TABLE(Table), EntreeTel,
                     1,2, 1,2, GTK_EXPAND | GTK_FILL,
                     GTK_FILL, 2, 5);
    /* Le label Adresse */
    Label = gtk_label_new("Adresse : ");
    gtk_table_attach(GTK_TABLE(Table), Label,
                     0,2, 2,3, GTK_EXPAND | GTK_FILL,
                     GTK_FILL, 2, 5);
    /* Le texte de l'adresse */
    /*  Cration du GtkScrolledWindow */
    Scr = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Scr),
                                   GTK_POLICY_AUTOMATIC,
                                   GTK_POLICY_AUTOMATIC);
    gtk_table_attach(GTK_TABLE(Table), Scr, 0,2, 3,4,
                     GTK_EXPAND | GTK_FILL | GTK_SHRINK,
                     GTK_EXPAND | GTK_FILL | GTK_SHRINK,
                     2, 5); 
    /* Cration du GtkText */
    TexteAdresse = gtk_text_new(NULL, NULL);
    gtk_container_add(GTK_CONTAINER(Scr), TexteAdresse);
    gtk_text_set_editable(GTK_TEXT(TexteAdresse), TRUE);

  /* La liste des ides */
    /*  Cration du GtkScrolledWindow */
    Scr = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Scr),
                                   GTK_POLICY_AUTOMATIC,
                                   GTK_POLICY_AUTOMATIC);

    gtk_paned_add1(GTK_PANED(HPaned), Scr);

    /* Cration du GtkList */
    CArbre = gtk_ctree_new_with_titles(1, 0, Titre);
    gtk_container_add(GTK_CONTAINER(Scr), CArbre);
    /* Cration des 26 noeuds des lettres */
    for (i=0 ; i<26 ; i++)
    {
      gchar *Textes[1];

      Textes[0] = g_strdup_printf("%c", 'A'+i);
      NoeudsLettre[i] = 
        gtk_ctree_insert_node(GTK_CTREE(CArbre),
                              NULL, NULL, Textes, 0,
                              NULL, NULL, NULL, NULL,
                              FALSE, TRUE);
      gtk_ctree_node_set_selectable(GTK_CTREE(CArbre),
                                    NoeudsLettre[i],
                                    FALSE);
      g_free(Textes[0]);
    }

    gtk_signal_connect(GTK_OBJECT(CArbre),
                       "tree_select_row",
                       (GtkSignalFunc)SelectionNom,
                       NULL);
    gtk_signal_connect(GTK_OBJECT(CArbre),
                       "tree_unselect_row",
                       (GtkSignalFunc)DeselectionNom,
                       NULL);

  /* Un sparateur horizontal */
  Separateur = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(BoiteV), Separateur,
                     FALSE, FALSE, 0);
  /* La boite horizontale des boutons */
  BoiteH = gtk_hbox_new(TRUE, 5);
  gtk_box_pack_start(GTK_BOX(BoiteV), BoiteH,
                     FALSE, FALSE, 0);
    /* Le bouton "Ajouter" */
    Bouton = gtk_button_new_with_label("Ajouter");
    gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Bouton);
    gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                       (GtkSignalFunc)DialogueAjouter,
                       NULL);
    /* Le bouton "Effacer" */
    Bouton = gtk_button_new_with_label("Effacer");
    gtk_box_pack_start_defaults(GTK_BOX(BoiteH), Bouton);
    gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                       (GtkSignalFunc)DialogueEffacer,
                       NULL);
}

