/* apropos.c */
#include <gtk/gtk.h>
#include "apropos.h"

static GtkWidget *DialogueAPropos = NULL;

void AfficheAPropos(void)
{
  GtkWidget *Label, *Bouton;
  if (DialogueAPropos)
  { /* Si la boite est dj cre, 
     * il suffit de la mettre en avant plan */
    gdk_window_raise(DialogueAPropos->window);
  } else
  { /* Sinon, on la cre vraiment */
    DialogueAPropos = gtk_dialog_new();
    /* On s'assure que DialogueAPropos revienne  NULL
       lorsqu'elle est dtruite. */
    gtk_signal_connect(GTK_OBJECT(DialogueAPropos),
                       "destroy",
                       GTK_SIGNAL_FUNC(gtk_widget_destroyed),
                       &DialogueAPropos);
    /* Le titre de la boite de dialogue */
    gtk_window_set_title(GTK_WINDOW(DialogueAPropos),
                         "A propos...");
    /* Connection du signal "delete_event"  */
    gtk_signal_connect(GTK_OBJECT(DialogueAPropos),
                       "delete_event",
                       (GtkSignalFunc)gtk_widget_destroy,
                       NULL);
    
    /* Le Label */
    Label = gtk_label_new("Agenda\n\n"
                          "un mini agenda\n"
                          "lectronique\n\n"
                          "crit par\n"
                          "David Odin\n"
                          "<David.Odin@bigfoot.com>");
    gtk_box_pack_start_defaults(
         GTK_BOX(GTK_DIALOG(DialogueAPropos)->vbox), Label);
    gtk_label_set_justify(GTK_LABEL(Label),
                          GTK_JUSTIFY_CENTER);
    gtk_misc_set_padding(GTK_MISC(Label), 10, 10);
    
    /* Le bouton OK */
    Bouton = gtk_button_new_with_label("OK");
    gtk_box_pack_start_defaults(
        GTK_BOX(GTK_DIALOG(DialogueAPropos)->action_area),
        Bouton);
    gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(DialogueAPropos));
    GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
    gtk_widget_grab_default(Bouton);

    gtk_widget_show_all(DialogueAPropos);
  }
}

