/* gdk rgb */
#include <gdk/gdk.h>
#include <gdk/gdkrgb.h>

#define LARGEUR (256)
#define HAUTEUR (256)

int main(int argc, char *argv[])
{
  GdkWindow *Fenetre;
  GdkPixmap *Fond;
  GdkWindowAttr attr;
  guchar image[3*LARGEUR*HAUTEUR];
  int x,y;
  gint depth;
  
  attr.event_mask = 0;
  attr.width = LARGEUR;
  attr.height = HAUTEUR;
  attr.wclass = GDK_INPUT_OUTPUT;
  attr.window_type = GDK_WINDOW_TOPLEVEL;
  gdk_init(&argc, &argv);
  gdk_rgb_init();
  /* Cration de la fentre */
  Fenetre = gdk_window_new(NULL, &attr, 0);
  /* Cration du pixmap de fond de la fentre */
  depth = gdk_window_get_visual(Fenetre)->depth;
  Fond = gdk_pixmap_new(Fenetre, 
                        LARGEUR, HAUTEUR,
                        depth);
  /* Cration du dgrad du jaune au bleu */
  for (y=0 ; y<256 ; y++)
    for (x=0 ; x<256 ; x++)
    { 
      /* Le rouge */
      image[3*(y*LARGEUR+x)+0] = 255-((x+y)%256);
      /* Le vert */
      image[3*(y*LARGEUR+x)+1] = 255-((x+y)%256);
      /* Le bleu */
      image[3*(y*LARGEUR+x)+2] = (x+y)%256;
    }
  /* L'image RVB 24 bits est copie dans le pixmap fond. */
  gdk_draw_rgb_image(Fond,
                     gdk_gc_new(Fenetre),
                     0,0, LARGEUR, HAUTEUR,
                     GDK_RGB_DITHER_NORMAL,
                     image,
                     3*LARGEUR);
  /* Le pixmap Fond devient le fond de la fentre */
  gdk_window_set_back_pixmap(Fenetre, Fond, FALSE);
  /* Affichage */
  gdk_window_show(Fenetre);
  /* Boucle d'attente des vnements */
  for(;;)
    if (gdk_events_pending())
      gdk_event_get();
}
