/* gdk souris */
#include <gdk/gdk.h>

#define NOMBRE_LIGNE (50)
typedef struct
{
  gint x1, y1, x2, y2;
} TypeLigne;

int NbLignes = 0;
int Index = 0;
TypeLigne Lignes[NOMBRE_LIGNE];

/*
 * Procdure de traitement des vnements
 * de type expose
 */
void TraitementExpose(GdkEventExpose *ev, gboolean force)
{
  GdkGC *gc;
  GdkColormap *colormap;
  GdkColor couleur;
  int i;

  /* Si ce n'est pas un appel depuis
   * TraitementMotion et si ce n'est pas le
   * dernier vnement expose de la srie, alors
   * on sort immdiatement 
   */
  if (force==FALSE && ev->count > 0)
    return;
  /* On efface la fentre */
  gdk_window_clear(ev->window);
  gc = gdk_gc_new(ev->window);
  colormap = gdk_colormap_get_system();
  gdk_color_white(colormap, &couleur);
  gdk_gc_set_foreground(gc, &couleur);
  for (i=0 ; i<NbLignes ; i++)
    gdk_draw_line(ev->window, gc, 
                  Lignes[i].x1, Lignes[i].y1,
                  Lignes[i].x2, Lignes[i].y2);
  gdk_gc_destroy(gc);
}

/*
 * Procdure de traitement des vnements
 * de type Button Press
 */
void TraitementButtonPress(GdkEventButton *ev)
{
  if (NbLignes < NOMBRE_LIGNE)
    NbLignes++;
  Lignes[Index].x1 = ev->x;
  Lignes[Index].y1 = ev->y;
}

/*
 * Procdure de traitement des vnements
 * de type mouvement de souris
 */
void TraitementMotion(GdkEventMotion *ev)
{
  int x, y;
  GdkModifierType mod;

  gdk_window_get_pointer(ev->window, &x, &y, &mod);
  Lignes[Index].x2 = x;
  Lignes[Index].y2 = y;
  /* on force le raffichage */
  TraitementExpose((GdkEventExpose *)ev, TRUE);
}

/*
 * Procdure de traitement des vnements
 * de type Button Release
 */
void TraitementButtonRelease(GdkEventButton *ev)
{
  Lignes[Index].x2 = ev->x;
  Lignes[Index].y2 = ev->y;
  /* on force le raffichage */
  TraitementExpose((GdkEventExpose *)ev, TRUE);
  Index++;
  Index %= NOMBRE_LIGNE;
}

int main(int argc, char *argv[])
{
  GdkWindow *Fenetre;
  GdkWindowAttr attr;
  GdkEvent *ev;
  gboolean fini = FALSE;
  
  attr.width = 150;
  attr.height = 150;
  attr.wclass = GDK_INPUT_OUTPUT;
  attr.window_type = GDK_WINDOW_TOPLEVEL;
  attr.event_mask = GDK_EXPOSURE_MASK |
                    GDK_BUTTON_MOTION_MASK |
                    GDK_POINTER_MOTION_HINT_MASK |
                    GDK_BUTTON_PRESS_MASK |
                    GDK_BUTTON_RELEASE_MASK;
  gdk_init(&argc, &argv);
  /* Cration de la fentre */
  Fenetre = gdk_window_new(NULL, &attr, 0);
  /* Affichage */
  gdk_window_show(Fenetre);
  /* Boucle d'attente des vnements */
  while (!fini)
    if (gdk_events_pending())
    {
      ev = gdk_event_get();
      if (ev)
      {
        switch (ev->type)
        {
          case GDK_DELETE:
            /* Si on recoit l'vnement delete,
             * on met fin  l'application
             */
            fini = TRUE;
            break;
          case GDK_EXPOSE:
            TraitementExpose((GdkEventExpose *)ev, FALSE);
            break;
          case GDK_BUTTON_PRESS:
            TraitementButtonPress((GdkEventButton *)ev);
            break;
          case GDK_MOTION_NOTIFY:
            TraitementMotion((GdkEventMotion *)ev);
            break;
          case GDK_BUTTON_RELEASE:
            TraitementButtonRelease((GdkEventButton *)ev);
          default:
            ;
        }
        gdk_event_free(ev);
      }
    }
  return 0;
}
