/* Packer.c */
#include <gtk/gtk.h>

/* Les cts */
GtkSideType side[] = { GTK_SIDE_TOP,
                       GTK_SIDE_LEFT,
                       GTK_SIDE_BOTTOM,
                       GTK_SIDE_RIGHT
                     };
/* Les points d'ancrage */
GtkAnchorType ancre[] = { GTK_ANCHOR_NORTH,
                          GTK_ANCHOR_NORTH_WEST,
                          GTK_ANCHOR_WEST,
                          GTK_ANCHOR_SOUTH_WEST,
                          GTK_ANCHOR_SOUTH,
                          GTK_ANCHOR_SOUTH_EAST,
                          GTK_ANCHOR_EAST,
                          GTK_ANCHOR_NORTH_EAST
                        };

void main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *Packer;
  GtkWidget *Bouton;
  int i;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* La fentre principale */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  /* Cration et attachement du packer */
  Packer = gtk_packer_new();
  gtk_container_add(GTK_CONTAINER(Fenetre), Packer);

  for (i=0 ; i<10 ; i++)
  {
    gchar *numero;

    numero = g_strdup_printf("%d", i);
    Bouton = gtk_button_new_with_label(numero);
    g_free(numero);
    gtk_packer_add(GTK_PACKER(Packer),
                   Bouton,
                   side[(i/2)%4],
                   ancre[i%8], 
                   0,
                   5, 5, 5, 3, 3);
  }
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);
  /* La boucle principale */
  gtk_main();
}
