/* Dialogue.c */
#include <stdio.h>
#include <gtk/gtk.h>

gboolean CallBack(GtkWidget *Bouton, gchar *texte)
{
  printf("%s\n", texte);
  return TRUE;
}

void main(int argc, char *argv[])
{
  GtkWidget *Dialogue;
  GtkWidget *Bouton;
  GtkWidget *Label;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre de dialogue */
  Dialogue = gtk_dialog_new();
  /* Le titre de la fentre de dialogue */
  gtk_window_set_title(GTK_WINDOW(Dialogue), "Dialogue");
  /* Connection des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Dialogue), "delete_event",
                     (GtkSignalFunc)gtk_exit,
                     NULL);
  gtk_signal_connect(GTK_OBJECT(Dialogue), "destroy",
                     (GtkSignalFunc)gtk_exit,
                     NULL);

  /* Le bouton OK */
  Bouton = gtk_button_new_with_label("OK");
  gtk_signal_connect(GTK_OBJECT(Bouton), "clicked",
                     (GtkSignalFunc)CallBack,
                     (gpointer)"Bouton OK");
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                         (GtkSignalFunc)gtk_widget_destroy,
                            GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_box_pack_start(
                GTK_BOX(GTK_DIALOG(Dialogue)->action_area),
                Bouton, TRUE, TRUE, 0);
  gtk_widget_grab_default(Bouton);
  /* Le bouton Annuler */
  Bouton = gtk_button_new_with_label("Annuler");
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
                           (GtkSignalFunc)gtk_widget_destroy,
                           GTK_OBJECT(Dialogue));
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_box_pack_start(
                GTK_BOX(GTK_DIALOG(Dialogue)->action_area),
                Bouton, TRUE, TRUE, 0);

  /* On place un label dans le corps de 
   * la bote de dialogue */
  Label = gtk_label_new("Corps de\nla bote\nde dialogue");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Dialogue)->vbox),
                     Label, TRUE, TRUE, 0);
  /* On affiche le tout */
  gtk_widget_show_all(Dialogue);      

  /* La boucle principale */
  gtk_main();
}
